/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      Symbol.bindElementAction(compId, symbolName, "${canstock19049507}", "click", function(sym, e) {
         
         // Replay a video track from the beginning, regardless of current playing state 
         sym.$("salade1")[0].currentTime = 0;
         if (sym.$("salade1")[0].paused) {
         	sym.$("salade1")[0].play();
         }
         
         // Show an element 
         sym.$("salade1").show();

      });
      //Edge binding end

      

      Symbol.bindElementAction(compId, symbolName, "${play}", "click", function(sym, e) {
         // insert code for mouse click here
         // Play a video track 
         sym.$("salade1")[0].play();
         
         // Show an element 
         sym.$("salade1").show();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${pause}", "click", function(sym, e) {
         // insert code for mouse click here
         // Pause a video track 
         sym.$("salade1")[0].pause();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${salade1}", "click", function(sym, e) {
         // insert code for mouse click here
         // Hide an element 
         sym.$("salade1").hide();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${Rectangle}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.getSymbol("instruction2").play();
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'instruction'
   (function(symbolName) {   
   
      Symbol.bindElementAction(compId, symbolName, "${Group}", "click", function(sym, e) {
         sym.play("Label1");

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         // insert code here
         sym.stop();

      });
      //Edge binding end

   })("instruction");
   //Edge symbol end:'instruction'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "EDGE-28521401");