var Kinetic={};(function(root){var PI_OVER_180=Math.PI/180;Kinetic={version:'5.1.0',stages:[],idCounter:0,ids:{},names:{},shapes:{},listenClickTap:false,inDblClickWindow:false,enableTrace:false,traceArrMax:100,dblClickWindow:400,pixelRatio:undefined,dragDistance:0,angleDeg:true,UA:(function(){var userAgent=(root.navigator&&root.navigator.userAgent)||'';var ua=userAgent.toLowerCase(),match=/(chrome)[ \/]([\w.]+)/.exec(ua)||/(webkit)[ \/]([\w.]+)/.exec(ua)||/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua)||/(msie) ([\w.]+)/.exec(ua)||ua.indexOf('compatible')<0&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua)||[],mobile=!!(userAgent.match(/Android|BlackBerry|iPhone|iPad|iPod|Opera Mini|IEMobile/i));return{browser:match[1]||'',version:match[2]||'0',mobile:mobile};})(),Filters:{},Node:function(config){this._init(config);},Shape:function(config){this.__init(config);},Container:function(config){this.__init(config);},Stage:function(config){this.___init(config);},BaseLayer:function(config){this.___init(config);},Layer:function(config){this.____init(config);},FastLayer:function(config){this.____init(config);},Group:function(config){this.___init(config);},isDragging:function(){var dd=Kinetic.DD;if(!dd){return false;}
else{return dd.isDragging;}},isDragReady:function(){var dd=Kinetic.DD;if(!dd){return false;}
else{return!!dd.node;}},_addId:function(node,id){if(id!==undefined){this.ids[id]=node;}},_removeId:function(id){if(id!==undefined){delete this.ids[id];}},_addName:function(node,name){if(name!==undefined){if(this.names[name]===undefined){this.names[name]=[];}
this.names[name].push(node);}},_removeName:function(name,_id){if(name!==undefined){var nodes=this.names[name];if(nodes!==undefined){for(var n=0;n<nodes.length;n++){var no=nodes[n];if(no._id===_id){nodes.splice(n,1);}}
if(nodes.length===0){delete this.names[name];}}}},getAngle:function(angle){return this.angleDeg?angle*PI_OVER_180:angle;}};})(this);(function(root,factory){if(typeof exports==='object'){var Canvas=require('canvas');var jsdom=require('jsdom').jsdom;var doc=jsdom('<!DOCTYPE html><html><head></head><body></body></html>');var KineticJS=factory();Kinetic.document=doc;Kinetic.window=Kinetic.document.createWindow();Kinetic.window.Image=Canvas.Image;Kinetic.root=root;Kinetic._nodeCanvas=Canvas;module.exports=KineticJS;return;}
else if(typeof define==='function'&&define.amd){define(factory);}
Kinetic.document=document;Kinetic.window=window;Kinetic.root=root;}((1,eval)('this'),function(){return Kinetic;}));;(function(){Kinetic.Collection=function(){var args=[].slice.call(arguments),length=args.length,i=0;this.length=length;for(;i<length;i++){this[i]=args[i];}
return this;};Kinetic.Collection.prototype=[];Kinetic.Collection.prototype.each=function(func){for(var n=0;n<this.length;n++){func(this[n],n);}};Kinetic.Collection.prototype.toArray=function(){var arr=[],len=this.length,n;for(n=0;n<len;n++){arr.push(this[n]);}
return arr;};Kinetic.Collection.toCollection=function(arr){var collection=new Kinetic.Collection(),len=arr.length,n;for(n=0;n<len;n++){collection.push(arr[n]);}
return collection;};Kinetic.Collection._mapMethod=function(methodName){Kinetic.Collection.prototype[methodName]=function(){var len=this.length,i;var args=[].slice.call(arguments);for(i=0;i<len;i++){this[i][methodName].apply(this[i],args);}
return this;};};Kinetic.Collection.mapMethods=function(constructor){var prot=constructor.prototype;for(var methodName in prot){Kinetic.Collection._mapMethod(methodName);}};Kinetic.Transform=function(m){this.m=(m&&m.slice())||[1,0,0,1,0,0];};Kinetic.Transform.prototype={copy:function(){return new Kinetic.Transform(this.m);},point:function(p){var m=this.m;return{x:m[0]*p.x+m[2]*p.y+m[4],y:m[1]*p.x+m[3]*p.y+m[5]};},translate:function(x,y){this.m[4]+=this.m[0]*x+this.m[2]*y;this.m[5]+=this.m[1]*x+this.m[3]*y;return this;},scale:function(sx,sy){this.m[0]*=sx;this.m[1]*=sx;this.m[2]*=sy;this.m[3]*=sy;return this;},rotate:function(rad){var c=Math.cos(rad);var s=Math.sin(rad);var m11=this.m[0]*c+this.m[2]*s;var m12=this.m[1]*c+this.m[3]*s;var m21=this.m[0]*-s+this.m[2]*c;var m22=this.m[1]*-s+this.m[3]*c;this.m[0]=m11;this.m[1]=m12;this.m[2]=m21;this.m[3]=m22;return this;},getTranslation:function(){return{x:this.m[4],y:this.m[5]};},skew:function(sx,sy){var m11=this.m[0]+this.m[2]*sy;var m12=this.m[1]+this.m[3]*sy;var m21=this.m[2]+this.m[0]*sx;var m22=this.m[3]+this.m[1]*sx;this.m[0]=m11;this.m[1]=m12;this.m[2]=m21;this.m[3]=m22;return this;},multiply:function(matrix){var m11=this.m[0]*matrix.m[0]+this.m[2]*matrix.m[1];var m12=this.m[1]*matrix.m[0]+this.m[3]*matrix.m[1];var m21=this.m[0]*matrix.m[2]+this.m[2]*matrix.m[3];var m22=this.m[1]*matrix.m[2]+this.m[3]*matrix.m[3];var dx=this.m[0]*matrix.m[4]+this.m[2]*matrix.m[5]+this.m[4];var dy=this.m[1]*matrix.m[4]+this.m[3]*matrix.m[5]+this.m[5];this.m[0]=m11;this.m[1]=m12;this.m[2]=m21;this.m[3]=m22;this.m[4]=dx;this.m[5]=dy;return this;},invert:function(){var d=1/(this.m[0]*this.m[3]-this.m[1]*this.m[2]);var m0=this.m[3]*d;var m1=-this.m[1]*d;var m2=-this.m[2]*d;var m3=this.m[0]*d;var m4=d*(this.m[2]*this.m[5]-this.m[3]*this.m[4]);var m5=d*(this.m[1]*this.m[4]-this.m[0]*this.m[5]);this.m[0]=m0;this.m[1]=m1;this.m[2]=m2;this.m[3]=m3;this.m[4]=m4;this.m[5]=m5;return this;},getMatrix:function(){return this.m;},setAbsolutePosition:function(x,y){var m0=this.m[0],m1=this.m[1],m2=this.m[2],m3=this.m[3],m4=this.m[4],m5=this.m[5],yt=((m0*(y-m5))-(m1*(x-m4)))/((m0*m3)-(m1*m2)),xt=(x-m4-(m2*yt))/m0;return this.translate(xt,yt);}};var CANVAS='canvas',CONTEXT_2D='2d',OBJECT_ARRAY='[object Array]',OBJECT_NUMBER='[object Number]',OBJECT_STRING='[object String]',PI_OVER_DEG180=Math.PI/180,DEG180_OVER_PI=180/Math.PI,HASH='#',EMPTY_STRING='',ZERO='0',KINETIC_WARNING='Kinetic warning: ',KINETIC_ERROR='Kinetic error: ',RGB_PAREN='rgb(',COLORS={aqua:[0,255,255],lime:[0,255,0],silver:[192,192,192],black:[0,0,0],maroon:[128,0,0],teal:[0,128,128],blue:[0,0,255],navy:[0,0,128],white:[255,255,255],fuchsia:[255,0,255],olive:[128,128,0],yellow:[255,255,0],orange:[255,165,0],gray:[128,128,128],purple:[128,0,128],green:[0,128,0],red:[255,0,0],pink:[255,192,203],cyan:[0,255,255],transparent:[255,255,255,0]},RGB_REGEX=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/;Kinetic.Util={_isElement:function(obj){return!!(obj&&obj.nodeType==1);},_isFunction:function(obj){return!!(obj&&obj.constructor&&obj.call&&obj.apply);},_isObject:function(obj){return(!!obj&&obj.constructor==Object);},_isArray:function(obj){return Object.prototype.toString.call(obj)==OBJECT_ARRAY;},_isNumber:function(obj){return Object.prototype.toString.call(obj)==OBJECT_NUMBER;},_isString:function(obj){return Object.prototype.toString.call(obj)==OBJECT_STRING;},_throttle:function(func,wait,options){var context,args,result;var timeout=null;var previous=0;options||(options={});var later=function(){previous=options.leading===false?0:new Date().getTime();timeout=null;result=func.apply(context,args);context=args=null;};return function(){var now=new Date().getTime();if(!previous&&options.leading===false)previous=now;var remaining=wait-(now-previous);context=this;args=arguments;if(remaining<=0){clearTimeout(timeout);timeout=null;previous=now;result=func.apply(context,args);context=args=null;}else if(!timeout&&options.trailing!==false){timeout=setTimeout(later,remaining);}
return result;};},_hasMethods:function(obj){var names=[],key;for(key in obj){if(this._isFunction(obj[key])){names.push(key);}}
return names.length>0;},createCanvasElement:function(){var canvas=Kinetic.document.createElement('canvas');canvas.style=canvas.style||{};return canvas;},isBrowser:function(){return(typeof exports!=='object');},_isInDocument:function(el){while(el=el.parentNode){if(el==Kinetic.document){return true;}}
return false;},_simplifyArray:function(arr){var retArr=[],len=arr.length,util=Kinetic.Util,n,val;for(n=0;n<len;n++){val=arr[n];if(util._isNumber(val)){val=Math.round(val*1000)/1000;}
else if(!util._isString(val)){val=val.toString();}
retArr.push(val);}
return retArr;},_getImage:function(arg,callback){var imageObj,canvas;if(!arg){callback(null);}
else if(this._isElement(arg)){callback(arg);}
else if(this._isString(arg)){imageObj=new Kinetic.window.Image();imageObj.onload=function(){callback(imageObj);};imageObj.src=arg;}
else if(arg.data){canvas=Kinetic.Util.createCanvasElement();canvas.width=arg.width;canvas.height=arg.height;var _context=canvas.getContext(CONTEXT_2D);_context.putImageData(arg,0,0);this._getImage(canvas.toDataURL(),callback);}
else{callback(null);}},_getRGBAString:function(obj){var red=obj.red||0,green=obj.green||0,blue=obj.blue||0,alpha=obj.alpha||1;return['rgba(',red,',',green,',',blue,',',alpha,')'].join(EMPTY_STRING);},_rgbToHex:function(r,g,b){return((1<<24)+(r<<16)+(g<<8)+b).toString(16).slice(1);},_hexToRgb:function(hex){hex=hex.replace(HASH,EMPTY_STRING);var bigint=parseInt(hex,16);return{r:(bigint>>16)&255,g:(bigint>>8)&255,b:bigint&255};},getRandomColor:function(){var randColor=(Math.random()*0xFFFFFF<<0).toString(16);while(randColor.length<6){randColor=ZERO+randColor;}
return HASH+randColor;},get:function(val,def){if(val===undefined){return def;}
else{return val;}},getRGB:function(color){var rgb;if(color in COLORS){rgb=COLORS[color];return{r:rgb[0],g:rgb[1],b:rgb[2]};}
else if(color[0]===HASH){return this._hexToRgb(color.substring(1));}
else if(color.substr(0,4)===RGB_PAREN){rgb=RGB_REGEX.exec(color.replace(/ /g,''));return{r:parseInt(rgb[1],10),g:parseInt(rgb[2],10),b:parseInt(rgb[3],10)};}
else{return{r:0,g:0,b:0};}},_merge:function(o1,o2){var retObj=this._clone(o2);for(var key in o1){if(this._isObject(o1[key])){retObj[key]=this._merge(o1[key],retObj[key]);}
else{retObj[key]=o1[key];}}
return retObj;},cloneObject:function(obj){var retObj={};for(var key in obj){if(this._isObject(obj[key])){retObj[key]=this.cloneObject(obj[key]);}
else if(this._isArray(obj[key])){retObj[key]=this.cloneArray(obj[key]);}else{retObj[key]=obj[key];}}
return retObj;},cloneArray:function(arr){return arr.slice(0);},_degToRad:function(deg){return deg*PI_OVER_DEG180;},_radToDeg:function(rad){return rad*DEG180_OVER_PI;},_capitalize:function(str){return str.charAt(0).toUpperCase()+str.slice(1);},error:function(str){throw new Error(KINETIC_ERROR+str);},warn:function(str){if(Kinetic.root.console&&console.warn){console.warn(KINETIC_WARNING+str);}},extend:function(c1,c2){for(var key in c2.prototype){if(!(key in c1.prototype)){c1.prototype[key]=c2.prototype[key];}}},addMethods:function(constructor,methods){var key;for(key in methods){constructor.prototype[key]=methods[key];}},_getControlPoints:function(x0,y0,x1,y1,x2,y2,t){var d01=Math.sqrt(Math.pow(x1-x0,2)+Math.pow(y1-y0,2)),d12=Math.sqrt(Math.pow(x2-x1,2)+Math.pow(y2-y1,2)),fa=t*d01/(d01+d12),fb=t*d12/(d01+d12),p1x=x1-fa*(x2-x0),p1y=y1-fa*(y2-y0),p2x=x1+fb*(x2-x0),p2y=y1+fb*(y2-y0);return[p1x,p1y,p2x,p2y];},_expandPoints:function(p,tension){var len=p.length,allPoints=[],n,cp;for(n=2;n<len-2;n+=2){cp=Kinetic.Util._getControlPoints(p[n-2],p[n-1],p[n],p[n+1],p[n+2],p[n+3],tension);allPoints.push(cp[0]);allPoints.push(cp[1]);allPoints.push(p[n]);allPoints.push(p[n+1]);allPoints.push(cp[2]);allPoints.push(cp[3]);}
return allPoints;},_removeLastLetter:function(str){return str.substring(0,str.length-1);}};})();;(function(){var canvas=Kinetic.Util.createCanvasElement(),context=canvas.getContext('2d'),_pixelRatio=Kinetic.UA.mobile?(function(){var devicePixelRatio=window.devicePixelRatio||1,backingStoreRatio=context.webkitBackingStorePixelRatio||context.mozBackingStorePixelRatio||context.msBackingStorePixelRatio||context.oBackingStorePixelRatio||context.backingStorePixelRatio||1;return devicePixelRatio/backingStoreRatio;})():1;Kinetic.Canvas=function(config){this.init(config);};Kinetic.Canvas.prototype={init:function(config){config=config||{};var pixelRatio=config.pixelRatio||Kinetic.pixelRatio||_pixelRatio;this.pixelRatio=pixelRatio;this._canvas=Kinetic.Util.createCanvasElement();this._canvas.style.padding=0;this._canvas.style.margin=0;this._canvas.style.border=0;this._canvas.style.background='transparent';this._canvas.style.position='absolute';this._canvas.style.top=0;this._canvas.style.left=0;},getContext:function(){return this.context;},getPixelRatio:function(){return this.pixelRatio;},setPixelRatio:function(pixelRatio){this.pixelRatio=pixelRatio;this.setSize(this.getWidth(),this.getHeight());},setWidth:function(width){this.width=this._canvas.width=width*this.pixelRatio;this._canvas.style.width=width+'px';},setHeight:function(height){this.height=this._canvas.height=height*this.pixelRatio;this._canvas.style.height=height+'px';},getWidth:function(){return this.width;},getHeight:function(){return this.height;},setSize:function(width,height){this.setWidth(width);this.setHeight(height);},toDataURL:function(mimeType,quality){try{return this._canvas.toDataURL(mimeType,quality);}
catch(e){try{return this._canvas.toDataURL();}
catch(err){Kinetic.Util.warn('Unable to get data URL. '+err.message);return'';}}}};Kinetic.SceneCanvas=function(config){config=config||{};var width=config.width||0,height=config.height||0;Kinetic.Canvas.call(this,config);this.context=new Kinetic.SceneContext(this);this.setSize(width,height);};Kinetic.SceneCanvas.prototype={setWidth:function(width){var pixelRatio=this.pixelRatio,_context=this.getContext()._context;Kinetic.Canvas.prototype.setWidth.call(this,width);_context.scale(pixelRatio,pixelRatio);},setHeight:function(height){var pixelRatio=this.pixelRatio,_context=this.getContext()._context;Kinetic.Canvas.prototype.setHeight.call(this,height);_context.scale(pixelRatio,pixelRatio);}};Kinetic.Util.extend(Kinetic.SceneCanvas,Kinetic.Canvas);Kinetic.HitCanvas=function(config){config=config||{};var width=config.width||0,height=config.height||0;Kinetic.Canvas.call(this,config);this.context=new Kinetic.HitContext(this);this.setSize(width,height);};Kinetic.Util.extend(Kinetic.HitCanvas,Kinetic.Canvas);})();;(function(){var COMMA=',',OPEN_PAREN='(',CLOSE_PAREN=')',OPEN_PAREN_BRACKET='([',CLOSE_BRACKET_PAREN='])',SEMICOLON=';',DOUBLE_PAREN='()',EQUALS='=',CONTEXT_METHODS=['arc','arcTo','beginPath','bezierCurveTo','clearRect','clip','closePath','createLinearGradient','createPattern','createRadialGradient','drawImage','fill','fillText','getImageData','createImageData','lineTo','moveTo','putImageData','quadraticCurveTo','rect','restore','rotate','save','scale','setLineDash','setTransform','stroke','strokeText','transform','translate'];Kinetic.Context=function(canvas){this.init(canvas);};Kinetic.Context.prototype={init:function(canvas){this.canvas=canvas;this._context=canvas._canvas.getContext('2d');if(Kinetic.enableTrace){this.traceArr=[];this._enableTrace();}},fillShape:function(shape){if(shape.getFillEnabled()){this._fill(shape);}},strokeShape:function(shape){if(shape.getStrokeEnabled()){this._stroke(shape);}},fillStrokeShape:function(shape){var fillEnabled=shape.getFillEnabled();if(fillEnabled){this._fill(shape);}
if(shape.getStrokeEnabled()){this._stroke(shape);}},getTrace:function(relaxed){var traceArr=this.traceArr,len=traceArr.length,str='',n,trace,method,args;for(n=0;n<len;n++){trace=traceArr[n];method=trace.method;if(method){args=trace.args;str+=method;if(relaxed){str+=DOUBLE_PAREN;}
else{if(Kinetic.Util._isArray(args[0])){str+=OPEN_PAREN_BRACKET+args.join(COMMA)+CLOSE_BRACKET_PAREN;}
else{str+=OPEN_PAREN+args.join(COMMA)+CLOSE_PAREN;}}}
else{str+=trace.property;if(!relaxed){str+=EQUALS+trace.val;}}
str+=SEMICOLON;}
return str;},clearTrace:function(){this.traceArr=[];},_trace:function(str){var traceArr=this.traceArr,len;traceArr.push(str);len=traceArr.length;if(len>=Kinetic.traceArrMax){traceArr.shift();}},reset:function(){var pixelRatio=this.getCanvas().getPixelRatio();this.setTransform(1*pixelRatio,0,0,1*pixelRatio,0,0);},getCanvas:function(){return this.canvas;},clear:function(bounds){var canvas=this.getCanvas();if(bounds){this.clearRect(bounds.x||0,bounds.y||0,bounds.width||0,bounds.height||0);}
else{this.clearRect(0,0,canvas.getWidth(),canvas.getHeight());}},_applyLineCap:function(shape){var lineCap=shape.getLineCap();if(lineCap){this.setAttr('lineCap',lineCap);}},_applyOpacity:function(shape){var absOpacity=shape.getAbsoluteOpacity();if(absOpacity!==1){this.setAttr('globalAlpha',absOpacity);}},_applyLineJoin:function(shape){var lineJoin=shape.getLineJoin();if(lineJoin){this.setAttr('lineJoin',lineJoin);}},setAttr:function(attr,val){this._context[attr]=val;},arc:function(){var a=arguments;this._context.arc(a[0],a[1],a[2],a[3],a[4],a[5]);},beginPath:function(){this._context.beginPath();},bezierCurveTo:function(){var a=arguments;this._context.bezierCurveTo(a[0],a[1],a[2],a[3],a[4],a[5]);},clearRect:function(){var a=arguments;this._context.clearRect(a[0],a[1],a[2],a[3]);},clip:function(){this._context.clip();},closePath:function(){this._context.closePath();},createImageData:function(){var a=arguments;if(a.length===2){return this._context.createImageData(a[0],a[1]);}
else if(a.length===1){return this._context.createImageData(a[0]);}},createLinearGradient:function(){var a=arguments;return this._context.createLinearGradient(a[0],a[1],a[2],a[3]);},createPattern:function(){var a=arguments;return this._context.createPattern(a[0],a[1]);},createRadialGradient:function(){var a=arguments;return this._context.createRadialGradient(a[0],a[1],a[2],a[3],a[4],a[5]);},drawImage:function(){var a=arguments,_context=this._context;if(a.length===3){_context.drawImage(a[0],a[1],a[2]);}
else if(a.length===5){_context.drawImage(a[0],a[1],a[2],a[3],a[4]);}
else if(a.length===9){_context.drawImage(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8]);}},fill:function(){this._context.fill();},fillText:function(){var a=arguments;this._context.fillText(a[0],a[1],a[2]);},getImageData:function(){var a=arguments;return this._context.getImageData(a[0],a[1],a[2],a[3]);},lineTo:function(){var a=arguments;this._context.lineTo(a[0],a[1]);},moveTo:function(){var a=arguments;this._context.moveTo(a[0],a[1]);},rect:function(){var a=arguments;this._context.rect(a[0],a[1],a[2],a[3]);},putImageData:function(){var a=arguments;this._context.putImageData(a[0],a[1],a[2]);},quadraticCurveTo:function(){var a=arguments;this._context.quadraticCurveTo(a[0],a[1],a[2],a[3]);},restore:function(){this._context.restore();},rotate:function(){var a=arguments;this._context.rotate(a[0]);},save:function(){this._context.save();},scale:function(){var a=arguments;this._context.scale(a[0],a[1]);},setLineDash:function(){var a=arguments,_context=this._context;if(this._context.setLineDash){_context.setLineDash(a[0]);}
else if('mozDash'in _context){_context.mozDash=a[0];}
else if('webkitLineDash'in _context){_context.webkitLineDash=a[0];}
},setTransform:function(){var a=arguments;this._context.setTransform(a[0],a[1],a[2],a[3],a[4],a[5]);},stroke:function(){this._context.stroke();},strokeText:function(){var a=arguments;this._context.strokeText(a[0],a[1],a[2]);},transform:function(){var a=arguments;this._context.transform(a[0],a[1],a[2],a[3],a[4],a[5]);},translate:function(){var a=arguments;this._context.translate(a[0],a[1]);},_enableTrace:function(){var that=this,len=CONTEXT_METHODS.length,_simplifyArray=Kinetic.Util._simplifyArray,origSetter=this.setAttr,n,args;var func=function(methodName){var origMethod=that[methodName],ret;that[methodName]=function(){args=_simplifyArray(Array.prototype.slice.call(arguments,0));ret=origMethod.apply(that,arguments);that._trace({method:methodName,args:args});return ret;};};for(n=0;n<len;n++){func(CONTEXT_METHODS[n]);}
that.setAttr=function(){origSetter.apply(that,arguments);that._trace({property:arguments[0],val:arguments[1]});};}};Kinetic.SceneContext=function(canvas){Kinetic.Context.call(this,canvas);};Kinetic.SceneContext.prototype={_fillColor:function(shape){var fill=shape.fill()||Kinetic.Util._getRGBAString({red:shape.fillRed(),green:shape.fillGreen(),blue:shape.fillBlue(),alpha:shape.fillAlpha()});this.setAttr('fillStyle',fill);shape._fillFunc(this);},_fillPattern:function(shape){var fillPatternImage=shape.getFillPatternImage(),fillPatternX=shape.getFillPatternX(),fillPatternY=shape.getFillPatternY(),fillPatternScale=shape.getFillPatternScale(),fillPatternRotation=Kinetic.getAngle(shape.getFillPatternRotation()),fillPatternOffset=shape.getFillPatternOffset(),fillPatternRepeat=shape.getFillPatternRepeat();if(fillPatternX||fillPatternY){this.translate(fillPatternX||0,fillPatternY||0);}
if(fillPatternRotation){this.rotate(fillPatternRotation);}
if(fillPatternScale){this.scale(fillPatternScale.x,fillPatternScale.y);}
if(fillPatternOffset){this.translate(-1*fillPatternOffset.x,-1*fillPatternOffset.y);}
this.setAttr('fillStyle',this.createPattern(fillPatternImage,fillPatternRepeat||'repeat'));this.fill();},_fillLinearGradient:function(shape){var start=shape.getFillLinearGradientStartPoint(),end=shape.getFillLinearGradientEndPoint(),colorStops=shape.getFillLinearGradientColorStops(),grd=this.createLinearGradient(start.x,start.y,end.x,end.y);if(colorStops){for(var n=0;n<colorStops.length;n+=2){grd.addColorStop(colorStops[n],colorStops[n+1]);}
this.setAttr('fillStyle',grd);this.fill();}},_fillRadialGradient:function(shape){var start=shape.getFillRadialGradientStartPoint(),end=shape.getFillRadialGradientEndPoint(),startRadius=shape.getFillRadialGradientStartRadius(),endRadius=shape.getFillRadialGradientEndRadius(),colorStops=shape.getFillRadialGradientColorStops(),grd=this.createRadialGradient(start.x,start.y,startRadius,end.x,end.y,endRadius);for(var n=0;n<colorStops.length;n+=2){grd.addColorStop(colorStops[n],colorStops[n+1]);}
this.setAttr('fillStyle',grd);this.fill();},_fill:function(shape){var hasColor=shape.fill()||shape.fillRed()||shape.fillGreen()||shape.fillBlue(),hasPattern=shape.getFillPatternImage(),hasLinearGradient=shape.getFillLinearGradientColorStops(),hasRadialGradient=shape.getFillRadialGradientColorStops(),fillPriority=shape.getFillPriority();if(hasColor&&fillPriority==='color'){this._fillColor(shape);}
else if(hasPattern&&fillPriority==='pattern'){this._fillPattern(shape);}
else if(hasLinearGradient&&fillPriority==='linear-gradient'){this._fillLinearGradient(shape);}
else if(hasRadialGradient&&fillPriority==='radial-gradient'){this._fillRadialGradient(shape);}
else if(hasColor){this._fillColor(shape);}
else if(hasPattern){this._fillPattern(shape);}
else if(hasLinearGradient){this._fillLinearGradient(shape);}
else if(hasRadialGradient){this._fillRadialGradient(shape);}},_stroke:function(shape){var dash=shape.dash(),strokeScaleEnabled=shape.getStrokeScaleEnabled();if(shape.hasStroke()){if(!strokeScaleEnabled){this.save();this.setTransform(1,0,0,1,0,0);}
this._applyLineCap(shape);if(dash&&shape.dashEnabled()){this.setLineDash(dash);}
this.setAttr('lineWidth',shape.strokeWidth());this.setAttr('strokeStyle',shape.stroke()||Kinetic.Util._getRGBAString({red:shape.strokeRed(),green:shape.strokeGreen(),blue:shape.strokeBlue(),alpha:shape.strokeAlpha()}));shape._strokeFunc(this);if(!strokeScaleEnabled){this.restore();}}},_applyShadow:function(shape){var util=Kinetic.Util,absOpacity=shape.getAbsoluteOpacity(),color=util.get(shape.getShadowColor(),'black'),blur=util.get(shape.getShadowBlur(),5),shadowOpacity=util.get(shape.getShadowOpacity(),1),offset=util.get(shape.getShadowOffset(),{x:0,y:0});if(shadowOpacity){this.setAttr('globalAlpha',shadowOpacity*absOpacity);}
this.setAttr('shadowColor',color);this.setAttr('shadowBlur',blur);this.setAttr('shadowOffsetX',offset.x);this.setAttr('shadowOffsetY',offset.y);}};Kinetic.Util.extend(Kinetic.SceneContext,Kinetic.Context);Kinetic.HitContext=function(canvas){Kinetic.Context.call(this,canvas);};Kinetic.HitContext.prototype={_fill:function(shape){this.save();this.setAttr('fillStyle',shape.colorKey);shape._fillFuncHit(this);this.restore();},_stroke:function(shape){if(shape.hasStroke()){this._applyLineCap(shape);this.setAttr('lineWidth',shape.strokeWidth());this.setAttr('strokeStyle',shape.colorKey);shape._strokeFuncHit(this);}}};Kinetic.Util.extend(Kinetic.HitContext,Kinetic.Context);})();;(function(){var ABSOLUTE_OPACITY='absoluteOpacity',ABSOLUTE_TRANSFORM='absoluteTransform',ADD='add',B='b',BEFORE='before',BLACK='black',CHANGE='Change',CHILDREN='children',DEG='Deg',DOT='.',EMPTY_STRING='',G='g',GET='get',HASH='#',ID='id',KINETIC='kinetic',LISTENING='listening',MOUSEENTER='mouseenter',MOUSELEAVE='mouseleave',NAME='name',OFF='off',ON='on',PRIVATE_GET='_get',R='r',RGB='RGB',SET='set',SHAPE='Shape',SPACE=' ',STAGE='Stage',TRANSFORM='transform',UPPER_B='B',UPPER_G='G',UPPER_HEIGHT='Height',UPPER_R='R',UPPER_WIDTH='Width',UPPER_X='X',UPPER_Y='Y',VISIBLE='visible',X='x',Y='y';Kinetic.Factory={addGetterSetter:function(constructor,attr,def,validator,after){this.addGetter(constructor,attr,def);this.addSetter(constructor,attr,validator,after);this.addOverloadedGetterSetter(constructor,attr);},addGetter:function(constructor,attr,def){var method=GET+Kinetic.Util._capitalize(attr);constructor.prototype[method]=function(){var val=this.attrs[attr];return val===undefined?def:val;};},addSetter:function(constructor,attr,validator,after){var method=SET+Kinetic.Util._capitalize(attr);constructor.prototype[method]=function(val){if(validator){val=validator.call(this,val);}
this._setAttr(attr,val);if(after){after.call(this);}
return this;};},addComponentsGetterSetter:function(constructor,attr,components,validator,after){var len=components.length,capitalize=Kinetic.Util._capitalize,getter=GET+capitalize(attr),setter=SET+capitalize(attr),n,component;constructor.prototype[getter]=function(){var ret={};for(n=0;n<len;n++){component=components[n];ret[component]=this.getAttr(attr+capitalize(component));}
return ret;};constructor.prototype[setter]=function(val){var oldVal=this.attrs[attr],key;if(validator){val=validator.call(this,val);}
for(key in val){this._setAttr(attr+capitalize(key),val[key]);}
this._fireChangeEvent(attr,oldVal,val);if(after){after.call(this);}
return this;};this.addOverloadedGetterSetter(constructor,attr);},addOverloadedGetterSetter:function(constructor,attr){var capitalizedAttr=Kinetic.Util._capitalize(attr),setter=SET+capitalizedAttr,getter=GET+capitalizedAttr;constructor.prototype[attr]=function(){if(arguments.length){this[setter](arguments[0]);return this;}
else{return this[getter]();}};},backCompat:function(constructor,methods){var key;for(key in methods){constructor.prototype[key]=constructor.prototype[methods[key]];}},afterSetFilter:function(){this._filterUpToDate=false;}};Kinetic.Validators={RGBComponent:function(val){if(val>255){return 255;}
else if(val<0){return 0;}
else{return Math.round(val);}},alphaComponent:function(val){if(val>1){return 1;}
else if(val<0.0001){return 0.0001;}
else{return val;}}};})();;(function(){var ABSOLUTE_OPACITY='absoluteOpacity',ABSOLUTE_TRANSFORM='absoluteTransform',BEFORE='before',CHANGE='Change',CHILDREN='children',DOT='.',EMPTY_STRING='',GET='get',ID='id',KINETIC='kinetic',LISTENING='listening',MOUSEENTER='mouseenter',MOUSELEAVE='mouseleave',NAME='name',SET='set',SHAPE='Shape',SPACE=' ',STAGE='stage',TRANSFORM='transform',UPPER_STAGE='Stage',VISIBLE='visible',CLONE_BLACK_LIST=['id'],TRANSFORM_CHANGE_STR=['xChange.kinetic','yChange.kinetic','scaleXChange.kinetic','scaleYChange.kinetic','skewXChange.kinetic','skewYChange.kinetic','rotationChange.kinetic','offsetXChange.kinetic','offsetYChange.kinetic','transformsEnabledChange.kinetic'].join(SPACE);Kinetic.Util.addMethods(Kinetic.Node,{_init:function(config){var that=this;this._id=Kinetic.idCounter++;this.eventListeners={};this.attrs={};this._cache={};this._filterUpToDate=false;this.setAttrs(config);this.on(TRANSFORM_CHANGE_STR,function(){this._clearCache(TRANSFORM);that._clearSelfAndDescendantCache(ABSOLUTE_TRANSFORM);});this.on('visibleChange.kinetic',function(){that._clearSelfAndDescendantCache(VISIBLE);});this.on('listeningChange.kinetic',function(){that._clearSelfAndDescendantCache(LISTENING);});this.on('opacityChange.kinetic',function(){that._clearSelfAndDescendantCache(ABSOLUTE_OPACITY);});},_clearCache:function(attr){if(attr){delete this._cache[attr];}
else{this._cache={};}},_getCache:function(attr,privateGetter){var cache=this._cache[attr];if(cache===undefined){this._cache[attr]=privateGetter.call(this);}
return this._cache[attr];},_clearSelfAndDescendantCache:function(attr){this._clearCache(attr);if(this.children){this.getChildren().each(function(node){node._clearSelfAndDescendantCache(attr);});}},clearCache:function(){delete this._cache.canvas;this._filterUpToDate=false;return this;},cache:function(config){var conf=config||{},x=conf.x||0,y=conf.y||0,width=conf.width||this.width(),height=conf.height||this.height(),drawBorder=conf.drawBorder||false,layer=this.getLayer();if(width===0||height===0){Kinetic.Util.warn('Width or height of caching configuration equals 0. Cache is ignored.');return;}
var cachedSceneCanvas=new Kinetic.SceneCanvas({pixelRatio:1,width:width,height:height}),cachedFilterCanvas=new Kinetic.SceneCanvas({pixelRatio:1,width:width,height:height}),cachedHitCanvas=new Kinetic.HitCanvas({width:width,height:height}),origTransEnabled=this.transformsEnabled(),origX=this.x(),origY=this.y(),sceneContext=cachedSceneCanvas.getContext(),hitContext=cachedHitCanvas.getContext();this.clearCache();sceneContext.save();hitContext.save();if(drawBorder){sceneContext.save();sceneContext.beginPath();sceneContext.rect(0,0,width,height);sceneContext.closePath();sceneContext.setAttr('strokeStyle','red');sceneContext.setAttr('lineWidth',5);sceneContext.stroke();sceneContext.restore();}
sceneContext.translate(x*-1,y*-1);hitContext.translate(x*-1,y*-1);if(this.nodeType==='Shape'){sceneContext.translate(this.x()*-1,this.y()*-1);hitContext.translate(this.x()*-1,this.y()*-1);}
this.drawScene(cachedSceneCanvas,this);this.drawHit(cachedHitCanvas,this);sceneContext.restore();hitContext.restore();this._cache.canvas={scene:cachedSceneCanvas,filter:cachedFilterCanvas,hit:cachedHitCanvas};return this;},_drawCachedSceneCanvas:function(context){context.save();this.getLayer()._applyTransform(this,context);context.drawImage(this._getCachedSceneCanvas()._canvas,0,0);context.restore();},_getCachedSceneCanvas:function(){var filters=this.filters(),cachedCanvas=this._cache.canvas,sceneCanvas=cachedCanvas.scene,filterCanvas=cachedCanvas.filter,filterContext=filterCanvas.getContext(),len,imageData,n,filter;if(filters){if(!this._filterUpToDate){try{len=filters.length;filterContext.clear();filterContext.drawImage(sceneCanvas._canvas,0,0);imageData=filterContext.getImageData(0,0,filterCanvas.getWidth(),filterCanvas.getHeight());for(n=0;n<len;n++){filter=filters[n];filter.call(this,imageData);filterContext.putImageData(imageData,0,0);}}
catch(e){Kinetic.Util.warn('Unable to apply filter. '+e.message);}
this._filterUpToDate=true;}
return filterCanvas;}
else{return sceneCanvas;}},_drawCachedHitCanvas:function(context){var cachedCanvas=this._cache.canvas,hitCanvas=cachedCanvas.hit;context.save();this.getLayer()._applyTransform(this,context);context.drawImage(hitCanvas._canvas,0,0);context.restore();},on:function(evtStr,handler){var events=evtStr.split(SPACE),len=events.length,n,event,parts,baseEvent,name;for(n=0;n<len;n++){event=events[n];parts=event.split(DOT);baseEvent=parts[0];name=parts[1]||EMPTY_STRING;if(!this.eventListeners[baseEvent]){this.eventListeners[baseEvent]=[];}
this.eventListeners[baseEvent].push({name:name,handler:handler});}
return this;},off:function(evtStr){var events=evtStr.split(SPACE),len=events.length,n,t,event,parts,baseEvent,name;for(n=0;n<len;n++){event=events[n];parts=event.split(DOT);baseEvent=parts[0];name=parts[1];if(baseEvent){if(this.eventListeners[baseEvent]){this._off(baseEvent,name);}}
else{for(t in this.eventListeners){this._off(t,name);}}}
return this;},dispatchEvent:function(evt){var e={target:this,type:evt.type,evt:evt};this.fire(evt.type,e);},addEventListener:function(type,handler){this.on(type,function(evt){handler.call(this,evt.evt);});},remove:function(){var parent=this.getParent();if(parent&&parent.children){parent.children.splice(this.index,1);parent._setChildrenIndices();delete this.parent;}
this._clearSelfAndDescendantCache(STAGE);this._clearSelfAndDescendantCache(ABSOLUTE_TRANSFORM);this._clearSelfAndDescendantCache(VISIBLE);this._clearSelfAndDescendantCache(LISTENING);this._clearSelfAndDescendantCache(ABSOLUTE_OPACITY);return this;},destroy:function(){Kinetic._removeId(this.getId());Kinetic._removeName(this.getName(),this._id);this.remove();},getAttr:function(attr){var method=GET+Kinetic.Util._capitalize(attr);if(Kinetic.Util._isFunction(this[method])){return this[method]();}
else{return this.attrs[attr];}},getAncestors:function(){var parent=this.getParent(),ancestors=new Kinetic.Collection();while(parent){ancestors.push(parent);parent=parent.getParent();}
return ancestors;},getAttrs:function(){return this.attrs||{};},setAttrs:function(config){var key,method;if(config){for(key in config){if(key===CHILDREN){}
else{method=SET+Kinetic.Util._capitalize(key);if(Kinetic.Util._isFunction(this[method])){this[method](config[key]);}
else{this._setAttr(key,config[key]);}}}}
return this;},isListening:function(){return this._getCache(LISTENING,this._isListening);},_isListening:function(){var listening=this.getListening(),parent=this.getParent();if(listening==='inherit'){if(parent){return parent.isListening();}
else{return true;}}
else{return listening;}},isVisible:function(){return this._getCache(VISIBLE,this._isVisible);},_isVisible:function(){var visible=this.getVisible(),parent=this.getParent();if(visible==='inherit'){if(parent){return parent.isVisible();}
else{return true;}}
else{return visible;}},shouldDrawHit:function(){var layer=this.getLayer();return layer&&layer.hitGraphEnabled()&&this.isListening()&&this.isVisible()&&!Kinetic.isDragging();},show:function(){this.setVisible(true);return this;},hide:function(){this.setVisible(false);return this;},getZIndex:function(){return this.index||0;},getAbsoluteZIndex:function(){var depth=this.getDepth(),that=this,index=0,nodes,len,n,child;function addChildren(children){nodes=[];len=children.length;for(n=0;n<len;n++){child=children[n];index++;if(child.nodeType!==SHAPE){nodes=nodes.concat(child.getChildren().toArray());}
if(child._id===that._id){n=len;}}
if(nodes.length>0&&nodes[0].getDepth()<=depth){addChildren(nodes);}}
if(that.nodeType!==UPPER_STAGE){addChildren(that.getStage().getChildren());}
return index;},getDepth:function(){var depth=0,parent=this.parent;while(parent){depth++;parent=parent.parent;}
return depth;},setPosition:function(pos){this.setX(pos.x);this.setY(pos.y);return this;},getPosition:function(){return{x:this.getX(),y:this.getY()};},getAbsolutePosition:function(){var absoluteMatrix=this.getAbsoluteTransform().getMatrix(),absoluteTransform=new Kinetic.Transform(),offset=this.offset();absoluteTransform.m=absoluteMatrix.slice();absoluteTransform.translate(offset.x,offset.y);return absoluteTransform.getTranslation();},setAbsolutePosition:function(pos){var origTrans=this._clearTransform(),it;this.attrs.x=origTrans.x;this.attrs.y=origTrans.y;delete origTrans.x;delete origTrans.y;it=this.getAbsoluteTransform();it.invert();it.translate(pos.x,pos.y);pos={x:this.attrs.x+it.getTranslation().x,y:this.attrs.y+it.getTranslation().y};this.setPosition({x:pos.x,y:pos.y});this._setTransform(origTrans);return this;},_setTransform:function(trans){var key;for(key in trans){this.attrs[key]=trans[key];}
this._clearCache(TRANSFORM);this._clearSelfAndDescendantCache(ABSOLUTE_TRANSFORM);},_clearTransform:function(){var trans={x:this.getX(),y:this.getY(),rotation:this.getRotation(),scaleX:this.getScaleX(),scaleY:this.getScaleY(),offsetX:this.getOffsetX(),offsetY:this.getOffsetY(),skewX:this.getSkewX(),skewY:this.getSkewY()};this.attrs.x=0;this.attrs.y=0;this.attrs.rotation=0;this.attrs.scaleX=1;this.attrs.scaleY=1;this.attrs.offsetX=0;this.attrs.offsetY=0;this.attrs.skewX=0;this.attrs.skewY=0;this._clearCache(TRANSFORM);this._clearSelfAndDescendantCache(ABSOLUTE_TRANSFORM);return trans;},move:function(change){var changeX=change.x,changeY=change.y,x=this.getX(),y=this.getY();if(changeX!==undefined){x+=changeX;}
if(changeY!==undefined){y+=changeY;}
this.setPosition({x:x,y:y});return this;},_eachAncestorReverse:function(func,top){var family=[],parent=this.getParent(),len,n;if(top&&top._id===this._id){func(this);return true;}
family.unshift(this);while(parent&&(!top||parent._id!==top._id)){family.unshift(parent);parent=parent.parent;}
len=family.length;for(n=0;n<len;n++){func(family[n]);}},rotate:function(theta){this.setRotation(this.getRotation()+theta);return this;},moveToTop:function(){if(!this.parent){Kinetic.Util.warn('Node has no parent. moveToTop function is ignored.');return;}
var index=this.index;this.parent.children.splice(index,1);this.parent.children.push(this);this.parent._setChildrenIndices();return true;},moveUp:function(){if(!this.parent){Kinetic.Util.warn('Node has no parent. moveUp function is ignored.');return;}
var index=this.index,len=this.parent.getChildren().length;if(index<len-1){this.parent.children.splice(index,1);this.parent.children.splice(index+1,0,this);this.parent._setChildrenIndices();return true;}
return false;},moveDown:function(){if(!this.parent){Kinetic.Util.warn('Node has no parent. moveDown function is ignored.');return;}
var index=this.index;if(index>0){this.parent.children.splice(index,1);this.parent.children.splice(index-1,0,this);this.parent._setChildrenIndices();return true;}
return false;},moveToBottom:function(){if(!this.parent){Kinetic.Util.warn('Node has no parent. moveToBottom function is ignored.');return;}
var index=this.index;if(index>0){this.parent.children.splice(index,1);this.parent.children.unshift(this);this.parent._setChildrenIndices();return true;}
return false;},setZIndex:function(zIndex){if(!this.parent){Kinetic.Util.warn('Node has no parent. zIndex parameter is ignored.');return;}
var index=this.index;this.parent.children.splice(index,1);this.parent.children.splice(zIndex,0,this);this.parent._setChildrenIndices();return this;},getAbsoluteOpacity:function(){return this._getCache(ABSOLUTE_OPACITY,this._getAbsoluteOpacity);},_getAbsoluteOpacity:function(){var absOpacity=this.getOpacity();if(this.getParent()){absOpacity*=this.getParent().getAbsoluteOpacity();}
return absOpacity;},moveTo:function(newContainer){Kinetic.Node.prototype.remove.call(this);newContainer.add(this);return this;},toObject:function(){var type=Kinetic.Util,obj={},attrs=this.getAttrs(),key,val,getter,defaultValue;obj.attrs={};for(key in attrs){val=attrs[key];if(!type._isFunction(val)&&!type._isElement(val)&&!(type._isObject(val)&&type._hasMethods(val))){getter=this[key];delete attrs[key];defaultValue=getter?getter.call(this):null;attrs[key]=val;if(defaultValue!==val){obj.attrs[key]=val;}}}
obj.className=this.getClassName();return obj;},toJSON:function(){return JSON.stringify(this.toObject());},getParent:function(){return this.parent;},getLayer:function(){var parent=this.getParent();return parent?parent.getLayer():null;},getStage:function(){return this._getCache(STAGE,this._getStage);},_getStage:function(){var parent=this.getParent();if(parent){return parent.getStage();}
else{return undefined;}},fire:function(eventType,evt,bubble){if(bubble){this._fireAndBubble(eventType,evt||{});}
else{this._fire(eventType,evt||{});}
return this;},getAbsoluteTransform:function(top){if(top){return this._getAbsoluteTransform(top);}
else{return this._getCache(ABSOLUTE_TRANSFORM,this._getAbsoluteTransform);}},_getAbsoluteTransform:function(top){var at=new Kinetic.Transform(),transformsEnabled,trans;this._eachAncestorReverse(function(node){transformsEnabled=node.transformsEnabled();trans=node.getTransform();if(transformsEnabled==='all'){at.multiply(trans);}
else if(transformsEnabled==='position'){at.translate(node.x(),node.y());}},top);return at;},getTransform:function(){return this._getCache(TRANSFORM,this._getTransform);},_getTransform:function(){var m=new Kinetic.Transform(),x=this.getX(),y=this.getY(),rotation=Kinetic.getAngle(this.getRotation()),scaleX=this.getScaleX(),scaleY=this.getScaleY(),skewX=this.getSkewX(),skewY=this.getSkewY(),offsetX=this.getOffsetX(),offsetY=this.getOffsetY();if(x!==0||y!==0){m.translate(x,y);}
if(rotation!==0){m.rotate(rotation);}
if(skewX!==0||skewY!==0){m.skew(skewX,skewY);}
if(scaleX!==1||scaleY!==1){m.scale(scaleX,scaleY);}
if(offsetX!==0||offsetY!==0){m.translate(-1*offsetX,-1*offsetY);}
return m;},clone:function(obj){var className=this.getClassName(),attrs=Kinetic.Util.cloneObject(this.attrs),key,allListeners,len,n,listener;for(var i in CLONE_BLACK_LIST){var blockAttr=CLONE_BLACK_LIST[i];delete attrs[blockAttr];}
for(key in obj){attrs[key]=obj[key];}
var node=new Kinetic[className](attrs);for(key in this.eventListeners){allListeners=this.eventListeners[key];len=allListeners.length;for(n=0;n<len;n++){listener=allListeners[n];if(listener.name.indexOf(KINETIC)<0){if(!node.eventListeners[key]){node.eventListeners[key]=[];}
node.eventListeners[key].push(listener);}}}
return node;},toDataURL:function(config){config=config||{};var mimeType=config.mimeType||null,quality=config.quality||null,stage=this.getStage(),x=config.x||0,y=config.y||0,canvas=new Kinetic.SceneCanvas({width:config.width||this.getWidth()||(stage?stage.getWidth():0),height:config.height||this.getHeight()||(stage?stage.getHeight():0),pixelRatio:1}),context=canvas.getContext();context.save();if(x||y){context.translate(-1*x,-1*y);}
this.drawScene(canvas);context.restore();return canvas.toDataURL(mimeType,quality);},toImage:function(config){Kinetic.Util._getImage(this.toDataURL(config),function(img){config.callback(img);});},setSize:function(size){this.setWidth(size.width);this.setHeight(size.height);return this;},getSize:function(){return{width:this.getWidth(),height:this.getHeight()};},getWidth:function(){return this.attrs.width||0;},getHeight:function(){return this.attrs.height||0;},getClassName:function(){return this.className||this.nodeType;},getType:function(){return this.nodeType;},getDragDistance:function(){if(this.attrs.dragDistance!==undefined){return this.attrs.dragDistance;}else if(this.parent){return this.parent.getDragDistance();}else{return Kinetic.dragDistance;}},_get:function(selector){return this.nodeType===selector?[this]:[];},_off:function(type,name){var evtListeners=this.eventListeners[type],i,evtName;for(i=0;i<evtListeners.length;i++){evtName=evtListeners[i].name;if((evtName!=='kinetic'||name==='kinetic')&&(!name||evtName===name)){evtListeners.splice(i,1);if(evtListeners.length===0){delete this.eventListeners[type];break;}
i--;}}},_fireChangeEvent:function(attr,oldVal,newVal){this._fire(attr+CHANGE,{oldVal:oldVal,newVal:newVal});},setId:function(id){var oldId=this.getId();Kinetic._removeId(oldId);Kinetic._addId(this,id);this._setAttr(ID,id);return this;},setName:function(name){var oldName=this.getName();Kinetic._removeName(oldName,this._id);Kinetic._addName(this,name);this._setAttr(NAME,name);return this;},setAttr:function(){var args=Array.prototype.slice.call(arguments),attr=args[0],val=args[1],method=SET+Kinetic.Util._capitalize(attr),func=this[method];if(Kinetic.Util._isFunction(func)){func.call(this,val);}
else{this._setAttr(attr,val);}
return this;},_setAttr:function(key,val){var oldVal;if(val!==undefined){oldVal=this.attrs[key];this.attrs[key]=val;this._fireChangeEvent(key,oldVal,val);}},_setComponentAttr:function(key,component,val){var oldVal;if(val!==undefined){oldVal=this.attrs[key];if(!oldVal){this.attrs[key]=this.getAttr(key);}
this.attrs[key][component]=val;this._fireChangeEvent(key,oldVal,val);}},_fireAndBubble:function(eventType,evt,compareShape){var okayToRun=true;if(evt&&this.nodeType===SHAPE){evt.target=this;}
if(eventType===MOUSEENTER&&compareShape&&this._id===compareShape._id){okayToRun=false;}
else if(eventType===MOUSELEAVE&&compareShape&&this._id===compareShape._id){okayToRun=false;}
if(okayToRun){this._fire(eventType,evt);if(evt&&!evt.cancelBubble&&this.parent){if(compareShape&&compareShape.parent){this._fireAndBubble.call(this.parent,eventType,evt,compareShape.parent);}
else{this._fireAndBubble.call(this.parent,eventType,evt);}}}},_fire:function(eventType,evt){var events=this.eventListeners[eventType],i;evt.type=eventType;if(events){for(i=0;i<events.length;i++){events[i].handler.call(this,evt);}}},draw:function(){this.drawScene();this.drawHit();return this;}});Kinetic.Node.create=function(json,container){return this._createNode(JSON.parse(json),container);};Kinetic.Node._createNode=function(obj,container){var className=Kinetic.Node.prototype.getClassName.call(obj),children=obj.children,no,len,n;if(container){obj.attrs.container=container;}
no=new Kinetic[className](obj.attrs);if(children){len=children.length;for(n=0;n<len;n++){no.add(this._createNode(children[n]));}}
return no;};Kinetic.Factory.addOverloadedGetterSetter(Kinetic.Node,'position');Kinetic.Factory.addGetterSetter(Kinetic.Node,'x',0);Kinetic.Factory.addGetterSetter(Kinetic.Node,'y',0);Kinetic.Factory.addGetterSetter(Kinetic.Node,'opacity',1);Kinetic.Factory.addGetter(Kinetic.Node,'name');Kinetic.Factory.addOverloadedGetterSetter(Kinetic.Node,'name');Kinetic.Factory.addGetter(Kinetic.Node,'id');Kinetic.Factory.addOverloadedGetterSetter(Kinetic.Node,'id');Kinetic.Factory.addGetterSetter(Kinetic.Node,'rotation',0);Kinetic.Factory.addComponentsGetterSetter(Kinetic.Node,'scale',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Node,'scaleX',1);Kinetic.Factory.addGetterSetter(Kinetic.Node,'scaleY',1);Kinetic.Factory.addComponentsGetterSetter(Kinetic.Node,'skew',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Node,'skewX',0);Kinetic.Factory.addGetterSetter(Kinetic.Node,'skewY',0);Kinetic.Factory.addComponentsGetterSetter(Kinetic.Node,'offset',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Node,'offsetX',0);Kinetic.Factory.addGetterSetter(Kinetic.Node,'offsetY',0);Kinetic.Factory.addSetter(Kinetic.Node,'dragDistance');Kinetic.Factory.addOverloadedGetterSetter(Kinetic.Node,'dragDistance');Kinetic.Factory.addSetter(Kinetic.Node,'width',0);Kinetic.Factory.addOverloadedGetterSetter(Kinetic.Node,'width');Kinetic.Factory.addSetter(Kinetic.Node,'height',0);Kinetic.Factory.addOverloadedGetterSetter(Kinetic.Node,'height');Kinetic.Factory.addGetterSetter(Kinetic.Node,'listening','inherit');Kinetic.Factory.addGetterSetter(Kinetic.Node,'filters',undefined,function(val){this._filterUpToDate=false;return val;});Kinetic.Factory.addGetterSetter(Kinetic.Node,'visible','inherit');Kinetic.Factory.addGetterSetter(Kinetic.Node,'transformsEnabled','all');Kinetic.Factory.addOverloadedGetterSetter(Kinetic.Node,'size');Kinetic.Factory.backCompat(Kinetic.Node,{rotateDeg:'rotate',setRotationDeg:'setRotation',getRotationDeg:'getRotation'});Kinetic.Collection.mapMethods(Kinetic.Node);})();;(function(){Kinetic.Filters.Grayscale=function(imageData){var data=imageData.data,len=data.length,i,brightness;for(i=0;i<len;i+=4){brightness=0.34*data[i]+0.5*data[i+1]+0.16*data[i+2];data[i]=brightness;data[i+1]=brightness;data[i+2]=brightness;}};})();;(function(){Kinetic.Filters.Brighten=function(imageData){var brightness=this.brightness()*255,data=imageData.data,len=data.length,i;for(i=0;i<len;i+=4){data[i]+=brightness;data[i+1]+=brightness;data[i+2]+=brightness;}};Kinetic.Factory.addGetterSetter(Kinetic.Node,'brightness',0,null,Kinetic.Factory.afterSetFilter);})();;(function(){Kinetic.Filters.Invert=function(imageData){var data=imageData.data,len=data.length,i;for(i=0;i<len;i+=4){data[i]=255-data[i];data[i+1]=255-data[i+1];data[i+2]=255-data[i+2];}};})();;(function(){function BlurStack(){this.r=0;this.g=0;this.b=0;this.a=0;this.next=null;}
var mul_table=[512,512,456,512,328,456,335,512,405,328,271,456,388,335,292,512,454,405,364,328,298,271,496,456,420,388,360,335,312,292,273,512,482,454,428,405,383,364,345,328,312,298,284,271,259,496,475,456,437,420,404,388,374,360,347,335,323,312,302,292,282,273,265,512,497,482,468,454,441,428,417,405,394,383,373,364,354,345,337,328,320,312,305,298,291,284,278,271,265,259,507,496,485,475,465,456,446,437,428,420,412,404,396,388,381,374,367,360,354,347,341,335,329,323,318,312,307,302,297,292,287,282,278,273,269,265,261,512,505,497,489,482,475,468,461,454,447,441,435,428,422,417,411,405,399,394,389,383,378,373,368,364,359,354,350,345,341,337,332,328,324,320,316,312,309,305,301,298,294,291,287,284,281,278,274,271,268,265,262,259,257,507,501,496,491,485,480,475,470,465,460,456,451,446,442,437,433,428,424,420,416,412,408,404,400,396,392,388,385,381,377,374,370,367,363,360,357,354,350,347,344,341,338,335,332,329,326,323,320,318,315,312,310,307,304,302,299,297,294,292,289,287,285,282,280,278,275,273,271,269,267,265,263,261,259];var shg_table=[9,11,12,13,13,14,14,15,15,15,15,16,16,16,16,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24];function filterGaussBlurRGBA(imageData,radius){var pixels=imageData.data,width=imageData.width,height=imageData.height;var x,y,i,p,yp,yi,yw,r_sum,g_sum,b_sum,a_sum,r_out_sum,g_out_sum,b_out_sum,a_out_sum,r_in_sum,g_in_sum,b_in_sum,a_in_sum,pr,pg,pb,pa,rbs;var div=radius+radius+1,widthMinus1=width-1,heightMinus1=height-1,radiusPlus1=radius+1,sumFactor=radiusPlus1*(radiusPlus1+1)/2,stackStart=new BlurStack(),stackEnd=null,stack=stackStart,stackIn=null,stackOut=null,mul_sum=mul_table[radius],shg_sum=shg_table[radius];for(i=1;i<div;i++){stack=stack.next=new BlurStack();if(i==radiusPlus1){stackEnd=stack;}}
stack.next=stackStart;yw=yi=0;for(y=0;y<height;y++)
{r_in_sum=g_in_sum=b_in_sum=a_in_sum=r_sum=g_sum=b_sum=a_sum=0;r_out_sum=radiusPlus1*(pr=pixels[yi]);g_out_sum=radiusPlus1*(pg=pixels[yi+1]);b_out_sum=radiusPlus1*(pb=pixels[yi+2]);a_out_sum=radiusPlus1*(pa=pixels[yi+3]);r_sum+=sumFactor*pr;g_sum+=sumFactor*pg;b_sum+=sumFactor*pb;a_sum+=sumFactor*pa;stack=stackStart;for(i=0;i<radiusPlus1;i++)
{stack.r=pr;stack.g=pg;stack.b=pb;stack.a=pa;stack=stack.next;}
for(i=1;i<radiusPlus1;i++)
{p=yi+((widthMinus1<i?widthMinus1:i)<<2);r_sum+=(stack.r=(pr=pixels[p]))*(rbs=radiusPlus1-i);g_sum+=(stack.g=(pg=pixels[p+1]))*rbs;b_sum+=(stack.b=(pb=pixels[p+2]))*rbs;a_sum+=(stack.a=(pa=pixels[p+3]))*rbs;r_in_sum+=pr;g_in_sum+=pg;b_in_sum+=pb;a_in_sum+=pa;stack=stack.next;}
stackIn=stackStart;stackOut=stackEnd;for(x=0;x<width;x++)
{pixels[yi+3]=pa=(a_sum*mul_sum)>>shg_sum;if(pa!==0)
{pa=255/pa;pixels[yi]=((r_sum*mul_sum)>>shg_sum)*pa;pixels[yi+1]=((g_sum*mul_sum)>>shg_sum)*pa;pixels[yi+2]=((b_sum*mul_sum)>>shg_sum)*pa;}else{pixels[yi]=pixels[yi+1]=pixels[yi+2]=0;}
r_sum-=r_out_sum;g_sum-=g_out_sum;b_sum-=b_out_sum;a_sum-=a_out_sum;r_out_sum-=stackIn.r;g_out_sum-=stackIn.g;b_out_sum-=stackIn.b;a_out_sum-=stackIn.a;p=(yw+((p=x+radius+1)<widthMinus1?p:widthMinus1))<<2;r_in_sum+=(stackIn.r=pixels[p]);g_in_sum+=(stackIn.g=pixels[p+1]);b_in_sum+=(stackIn.b=pixels[p+2]);a_in_sum+=(stackIn.a=pixels[p+3]);r_sum+=r_in_sum;g_sum+=g_in_sum;b_sum+=b_in_sum;a_sum+=a_in_sum;stackIn=stackIn.next;r_out_sum+=(pr=stackOut.r);g_out_sum+=(pg=stackOut.g);b_out_sum+=(pb=stackOut.b);a_out_sum+=(pa=stackOut.a);r_in_sum-=pr;g_in_sum-=pg;b_in_sum-=pb;a_in_sum-=pa;stackOut=stackOut.next;yi+=4;}
yw+=width;}
for(x=0;x<width;x++)
{g_in_sum=b_in_sum=a_in_sum=r_in_sum=g_sum=b_sum=a_sum=r_sum=0;yi=x<<2;r_out_sum=radiusPlus1*(pr=pixels[yi]);g_out_sum=radiusPlus1*(pg=pixels[yi+1]);b_out_sum=radiusPlus1*(pb=pixels[yi+2]);a_out_sum=radiusPlus1*(pa=pixels[yi+3]);r_sum+=sumFactor*pr;g_sum+=sumFactor*pg;b_sum+=sumFactor*pb;a_sum+=sumFactor*pa;stack=stackStart;for(i=0;i<radiusPlus1;i++)
{stack.r=pr;stack.g=pg;stack.b=pb;stack.a=pa;stack=stack.next;}
yp=width;for(i=1;i<=radius;i++)
{yi=(yp+x)<<2;r_sum+=(stack.r=(pr=pixels[yi]))*(rbs=radiusPlus1-i);g_sum+=(stack.g=(pg=pixels[yi+1]))*rbs;b_sum+=(stack.b=(pb=pixels[yi+2]))*rbs;a_sum+=(stack.a=(pa=pixels[yi+3]))*rbs;r_in_sum+=pr;g_in_sum+=pg;b_in_sum+=pb;a_in_sum+=pa;stack=stack.next;if(i<heightMinus1)
{yp+=width;}}
yi=x;stackIn=stackStart;stackOut=stackEnd;for(y=0;y<height;y++)
{p=yi<<2;pixels[p+3]=pa=(a_sum*mul_sum)>>shg_sum;if(pa>0)
{pa=255/pa;pixels[p]=((r_sum*mul_sum)>>shg_sum)*pa;pixels[p+1]=((g_sum*mul_sum)>>shg_sum)*pa;pixels[p+2]=((b_sum*mul_sum)>>shg_sum)*pa;}else{pixels[p]=pixels[p+1]=pixels[p+2]=0;}
r_sum-=r_out_sum;g_sum-=g_out_sum;b_sum-=b_out_sum;a_sum-=a_out_sum;r_out_sum-=stackIn.r;g_out_sum-=stackIn.g;b_out_sum-=stackIn.b;a_out_sum-=stackIn.a;p=(x+(((p=y+radiusPlus1)<heightMinus1?p:heightMinus1)*width))<<2;r_sum+=(r_in_sum+=(stackIn.r=pixels[p]));g_sum+=(g_in_sum+=(stackIn.g=pixels[p+1]));b_sum+=(b_in_sum+=(stackIn.b=pixels[p+2]));a_sum+=(a_in_sum+=(stackIn.a=pixels[p+3]));stackIn=stackIn.next;r_out_sum+=(pr=stackOut.r);g_out_sum+=(pg=stackOut.g);b_out_sum+=(pb=stackOut.b);a_out_sum+=(pa=stackOut.a);r_in_sum-=pr;g_in_sum-=pg;b_in_sum-=pb;a_in_sum-=pa;stackOut=stackOut.next;yi+=width;}}}
Kinetic.Filters.Blur=function(imageData){var radius=Math.round(this.blurRadius());if(radius>0){filterGaussBlurRGBA(imageData,radius);}};Kinetic.Factory.addGetterSetter(Kinetic.Node,'blurRadius',0,null,Kinetic.Factory.afterSetFilter);})();;(function(){function pixelAt(idata,x,y){var idx=(y*idata.width+x)*4;var d=[];d.push(idata.data[idx++],idata.data[idx++],idata.data[idx++],idata.data[idx++]);return d;}
function rgbDistance(p1,p2){return Math.sqrt(Math.pow(p1[0]-p2[0],2)+Math.pow(p1[1]-p2[1],2)+Math.pow(p1[2]-p2[2],2));}
function rgbMean(pTab){var m=[0,0,0];for(var i=0;i<pTab.length;i++){m[0]+=pTab[i][0];m[1]+=pTab[i][1];m[2]+=pTab[i][2];}
m[0]/=pTab.length;m[1]/=pTab.length;m[2]/=pTab.length;return m;}
function backgroundMask(idata,threshold){var rgbv_no=pixelAt(idata,0,0);var rgbv_ne=pixelAt(idata,idata.width-1,0);var rgbv_so=pixelAt(idata,0,idata.height-1);var rgbv_se=pixelAt(idata,idata.width-1,idata.height-1);var thres=threshold||10;if(rgbDistance(rgbv_no,rgbv_ne)<thres&&rgbDistance(rgbv_ne,rgbv_se)<thres&&rgbDistance(rgbv_se,rgbv_so)<thres&&rgbDistance(rgbv_so,rgbv_no)<thres){var mean=rgbMean([rgbv_ne,rgbv_no,rgbv_se,rgbv_so]);var mask=[];for(var i=0;i<idata.width*idata.height;i++){var d=rgbDistance(mean,[idata.data[i*4],idata.data[i*4+1],idata.data[i*4+2]]);mask[i]=(d<thres)?0:255;}
return mask;}}
function applyMask(idata,mask){for(var i=0;i<idata.width*idata.height;i++){idata.data[4*i+3]=mask[i];}}
function erodeMask(mask,sw,sh){var weights=[1,1,1,1,0,1,1,1,1];var side=Math.round(Math.sqrt(weights.length));var halfSide=Math.floor(side/2);var maskResult=[];for(var y=0;y<sh;y++){for(var x=0;x<sw;x++){var so=y*sw+x;var a=0;for(var cy=0;cy<side;cy++){for(var cx=0;cx<side;cx++){var scy=y+cy-halfSide;var scx=x+cx-halfSide;if(scy>=0&&scy<sh&&scx>=0&&scx<sw){var srcOff=scy*sw+scx;var wt=weights[cy*side+cx];a+=mask[srcOff]*wt;}}}
maskResult[so]=(a===255*8)?255:0;}}
return maskResult;}
function dilateMask(mask,sw,sh){var weights=[1,1,1,1,1,1,1,1,1];var side=Math.round(Math.sqrt(weights.length));var halfSide=Math.floor(side/2);var maskResult=[];for(var y=0;y<sh;y++){for(var x=0;x<sw;x++){var so=y*sw+x;var a=0;for(var cy=0;cy<side;cy++){for(var cx=0;cx<side;cx++){var scy=y+cy-halfSide;var scx=x+cx-halfSide;if(scy>=0&&scy<sh&&scx>=0&&scx<sw){var srcOff=scy*sw+scx;var wt=weights[cy*side+cx];a+=mask[srcOff]*wt;}}}
maskResult[so]=(a>=255*4)?255:0;}}
return maskResult;}
function smoothEdgeMask(mask,sw,sh){var weights=[1/9,1/9,1/9,1/9,1/9,1/9,1/9,1/9,1/9];var side=Math.round(Math.sqrt(weights.length));var halfSide=Math.floor(side/2);var maskResult=[];for(var y=0;y<sh;y++){for(var x=0;x<sw;x++){var so=y*sw+x;var a=0;for(var cy=0;cy<side;cy++){for(var cx=0;cx<side;cx++){var scy=y+cy-halfSide;var scx=x+cx-halfSide;if(scy>=0&&scy<sh&&scx>=0&&scx<sw){var srcOff=scy*sw+scx;var wt=weights[cy*side+cx];a+=mask[srcOff]*wt;}}}
maskResult[so]=a;}}
return maskResult;}
Kinetic.Filters.Mask=function(imageData){var threshold=this.threshold(),mask=backgroundMask(imageData,threshold);if(mask){mask=erodeMask(mask,imageData.width,imageData.height);mask=dilateMask(mask,imageData.width,imageData.height);mask=smoothEdgeMask(mask,imageData.width,imageData.height);applyMask(imageData,mask);}
return imageData;};Kinetic.Factory.addGetterSetter(Kinetic.Node,'threshold',0,null,Kinetic.Factory.afterSetFilter);})();;(function(){Kinetic.Filters.RGB=function(imageData){var data=imageData.data,nPixels=data.length,red=this.red(),green=this.green(),blue=this.blue(),i,brightness;for(i=0;i<nPixels;i+=4){brightness=(0.34*data[i]+0.5*data[i+1]+0.16*data[i+2])/255;data[i]=brightness*red;data[i+1]=brightness*green;data[i+2]=brightness*blue;data[i+3]=data[i+3];}};Kinetic.Factory.addGetterSetter(Kinetic.Node,'red',0,function(val){this._filterUpToDate=false;if(val>255){return 255;}
else if(val<0){return 0;}
else{return Math.round(val);}});Kinetic.Factory.addGetterSetter(Kinetic.Node,'green',0,function(val){this._filterUpToDate=false;if(val>255){return 255;}
else if(val<0){return 0;}
else{return Math.round(val);}});Kinetic.Factory.addGetterSetter(Kinetic.Node,'blue',0,Kinetic.Validators.RGBComponent,Kinetic.Factory.afterSetFilter);})();;(function(){Kinetic.Filters.HSV=function(imageData){var data=imageData.data,nPixels=data.length,v=Math.pow(2,this.value()),s=Math.pow(2,this.saturation()),h=Math.abs((this.hue())+360)%360,i;var vsu=v*s*Math.cos(h*Math.PI/180),vsw=v*s*Math.sin(h*Math.PI/180);var rr=0.299*v+0.701*vsu+0.167*vsw,rg=0.587*v-0.587*vsu+0.330*vsw,rb=0.114*v-0.114*vsu-0.497*vsw;var gr=0.299*v-0.299*vsu-0.328*vsw,gg=0.587*v+0.413*vsu+0.035*vsw,gb=0.114*v-0.114*vsu+0.293*vsw;var br=0.299*v-0.300*vsu+1.250*vsw,bg=0.587*v-0.586*vsu-1.050*vsw,bb=0.114*v+0.886*vsu-0.200*vsw;var r,g,b,a;for(i=0;i<nPixels;i+=4){r=data[i+0];g=data[i+1];b=data[i+2];a=data[i+3];data[i+0]=rr*r+rg*g+rb*b;data[i+1]=gr*r+gg*g+gb*b;data[i+2]=br*r+bg*g+bb*b;data[i+3]=a;}};Kinetic.Factory.addGetterSetter(Kinetic.Node,'hue',0,null,Kinetic.Factory.afterSetFilter);Kinetic.Factory.addGetterSetter(Kinetic.Node,'saturation',0,null,Kinetic.Factory.afterSetFilter);Kinetic.Factory.addGetterSetter(Kinetic.Node,'value',0,null,Kinetic.Factory.afterSetFilter);})();;(function(){Kinetic.Factory.addGetterSetter(Kinetic.Node,'hue',0,null,Kinetic.Factory.afterSetFilter);Kinetic.Factory.addGetterSetter(Kinetic.Node,'saturation',0,null,Kinetic.Factory.afterSetFilter);Kinetic.Factory.addGetterSetter(Kinetic.Node,'luminance',0,null,Kinetic.Factory.afterSetFilter);Kinetic.Filters.HSL=function(imageData){var data=imageData.data,nPixels=data.length,v=1,s=Math.pow(2,this.saturation()),h=Math.abs((this.hue())+360)%360,l=this.luminance()*127,i;var vsu=v*s*Math.cos(h*Math.PI/180),vsw=v*s*Math.sin(h*Math.PI/180);var rr=0.299*v+0.701*vsu+0.167*vsw,rg=0.587*v-0.587*vsu+0.330*vsw,rb=0.114*v-0.114*vsu-0.497*vsw;var gr=0.299*v-0.299*vsu-0.328*vsw,gg=0.587*v+0.413*vsu+0.035*vsw,gb=0.114*v-0.114*vsu+0.293*vsw;var br=0.299*v-0.300*vsu+1.250*vsw,bg=0.587*v-0.586*vsu-1.050*vsw,bb=0.114*v+0.886*vsu-0.200*vsw;var r,g,b,a;for(i=0;i<nPixels;i+=4){r=data[i+0];g=data[i+1];b=data[i+2];a=data[i+3];data[i+0]=rr*r+rg*g+rb*b+l;data[i+1]=gr*r+gg*g+gb*b+l;data[i+2]=br*r+bg*g+bb*b+l;data[i+3]=a;}};})();;(function(){Kinetic.Filters.Emboss=function(imageData){var strength=this.embossStrength()*10,greyLevel=this.embossWhiteLevel()*255,direction=this.embossDirection(),blend=this.embossBlend(),dirY=0,dirX=0,data=imageData.data,w=imageData.width,h=imageData.height,w4=w*4,y=h;switch(direction){case'top-left':dirY=-1;dirX=-1;break;case'top':dirY=-1;dirX=0;break;case'top-right':dirY=-1;dirX=1;break;case'right':dirY=0;dirX=1;break;case'bottom-right':dirY=1;dirX=1;break;case'bottom':dirY=1;dirX=0;break;case'bottom-left':dirY=1;dirX=-1;break;case'left':dirY=0;dirX=-1;break;}
do{var offsetY=(y-1)*w4;var otherY=dirY;if(y+otherY<1){otherY=0;}
if(y+otherY>h){otherY=0;}
var offsetYOther=(y-1+otherY)*w*4;var x=w;do{var offset=offsetY+(x-1)*4;var otherX=dirX;if(x+otherX<1){otherX=0;}
if(x+otherX>w){otherX=0;}
var offsetOther=offsetYOther+(x-1+otherX)*4;var dR=data[offset]-data[offsetOther];var dG=data[offset+1]-data[offsetOther+1];var dB=data[offset+2]-data[offsetOther+2];var dif=dR;var absDif=dif>0?dif:-dif;var absG=dG>0?dG:-dG;var absB=dB>0?dB:-dB;if(absG>absDif){dif=dG;}
if(absB>absDif){dif=dB;}
dif*=strength;if(blend){var r=data[offset]+dif;var g=data[offset+1]+dif;var b=data[offset+2]+dif;data[offset]=(r>255)?255:(r<0?0:r);data[offset+1]=(g>255)?255:(g<0?0:g);data[offset+2]=(b>255)?255:(b<0?0:b);}else{var grey=greyLevel-dif;if(grey<0){grey=0;}else if(grey>255){grey=255;}
data[offset]=data[offset+1]=data[offset+2]=grey;}}while(--x);}while(--y);};Kinetic.Factory.addGetterSetter(Kinetic.Node,'embossStrength',0.5,null,Kinetic.Factory.afterSetFilter);Kinetic.Factory.addGetterSetter(Kinetic.Node,'embossWhiteLevel',0.5,null,Kinetic.Factory.afterSetFilter);Kinetic.Factory.addGetterSetter(Kinetic.Node,'embossDirection','top-left',null,Kinetic.Factory.afterSetFilter);Kinetic.Factory.addGetterSetter(Kinetic.Node,'embossBlend',false,null,Kinetic.Factory.afterSetFilter);})();;(function(){function remap(fromValue,fromMin,fromMax,toMin,toMax){var fromRange=fromMax-fromMin,toRange=toMax-toMin,toValue;if(fromRange===0){return toMin+toRange/2;}
if(toRange===0){return toMin;}
toValue=(fromValue-fromMin)/fromRange;toValue=(toRange*toValue)+toMin;return toValue;}
Kinetic.Filters.Enhance=function(imageData){var data=imageData.data,nSubPixels=data.length,rMin=data[0],rMax=rMin,r,gMin=data[1],gMax=gMin,g,bMin=data[2],bMax=bMin,b,aMin=data[3],aMax=aMin,i;var enhanceAmount=this.enhance();if(enhanceAmount===0){return;}
for(i=0;i<nSubPixels;i+=4){r=data[i+0];if(r<rMin){rMin=r;}
else if(r>rMax){rMax=r;}
g=data[i+1];if(g<gMin){gMin=g;}else
if(g>gMax){gMax=g;}
b=data[i+2];if(b<bMin){bMin=b;}else
if(b>bMax){bMax=b;}
}
if(rMax===rMin){rMax=255;rMin=0;}
if(gMax===gMin){gMax=255;gMin=0;}
if(bMax===bMin){bMax=255;bMin=0;}
if(aMax===aMin){aMax=255;aMin=0;}
var rMid,rGoalMax,rGoalMin,gMid,gGoalMax,gGoalMin,bMid,bGoalMax,aGoalMin,aMid,aGoalMax,bGoalMin;if(enhanceAmount>0){rGoalMax=rMax+enhanceAmount*(255-rMax);rGoalMin=rMin-enhanceAmount*(rMin-0);gGoalMax=gMax+enhanceAmount*(255-gMax);gGoalMin=gMin-enhanceAmount*(gMin-0);bGoalMax=bMax+enhanceAmount*(255-bMax);bGoalMin=bMin-enhanceAmount*(bMin-0);aGoalMax=aMax+enhanceAmount*(255-aMax);aGoalMin=aMin-enhanceAmount*(aMin-0);}else{rMid=(rMax+rMin)*0.5;rGoalMax=rMax+enhanceAmount*(rMax-rMid);rGoalMin=rMin+enhanceAmount*(rMin-rMid);gMid=(gMax+gMin)*0.5;gGoalMax=gMax+enhanceAmount*(gMax-gMid);gGoalMin=gMin+enhanceAmount*(gMin-gMid);bMid=(bMax+bMin)*0.5;bGoalMax=bMax+enhanceAmount*(bMax-bMid);bGoalMin=bMin+enhanceAmount*(bMin-bMid);aMid=(aMax+aMin)*0.5;aGoalMax=aMax+enhanceAmount*(aMax-aMid);aGoalMin=aMin+enhanceAmount*(aMin-aMid);}
for(i=0;i<nSubPixels;i+=4){data[i+0]=remap(data[i+0],rMin,rMax,rGoalMin,rGoalMax);data[i+1]=remap(data[i+1],gMin,gMax,gGoalMin,gGoalMax);data[i+2]=remap(data[i+2],bMin,bMax,bGoalMin,bGoalMax);}};Kinetic.Factory.addGetterSetter(Kinetic.Node,'enhance',0,null,Kinetic.Factory.afterSetFilter);})();;(function(){Kinetic.Filters.Posterize=function(imageData){var levels=Math.round(this.levels()*254)+1,data=imageData.data,len=data.length,scale=(255/levels),i;for(i=0;i<len;i+=1){data[i]=Math.floor(data[i]/scale)*scale;}};Kinetic.Factory.addGetterSetter(Kinetic.Node,'levels',0.5,null,Kinetic.Factory.afterSetFilter);})();;(function(){Kinetic.Filters.Noise=function(imageData){var amount=this.noise()*255,data=imageData.data,nPixels=data.length,half=amount/2,i;for(i=0;i<nPixels;i+=4){data[i+0]+=half-2*half*Math.random();data[i+1]+=half-2*half*Math.random();data[i+2]+=half-2*half*Math.random();}};Kinetic.Factory.addGetterSetter(Kinetic.Node,'noise',0.2,null,Kinetic.Factory.afterSetFilter);})();;(function(){Kinetic.Filters.Pixelate=function(imageData){var pixelSize=Math.ceil(this.pixelSize()),width=imageData.width,height=imageData.height,x,y,i,red,green,blue,alpha,nBinsX=Math.ceil(width/pixelSize),nBinsY=Math.ceil(height/pixelSize),xBinStart,xBinEnd,yBinStart,yBinEnd,xBin,yBin,pixelsInBin;imageData=imageData.data;for(xBin=0;xBin<nBinsX;xBin+=1){for(yBin=0;yBin<nBinsY;yBin+=1){red=0;green=0;blue=0;alpha=0;xBinStart=xBin*pixelSize;xBinEnd=xBinStart+pixelSize;yBinStart=yBin*pixelSize;yBinEnd=yBinStart+pixelSize;pixelsInBin=0;for(x=xBinStart;x<xBinEnd;x+=1){if(x>=width){continue;}
for(y=yBinStart;y<yBinEnd;y+=1){if(y>=height){continue;}
i=(width*y+x)*4;red+=imageData[i+0];green+=imageData[i+1];blue+=imageData[i+2];alpha+=imageData[i+3];pixelsInBin+=1;}}
red=red/pixelsInBin;green=green/pixelsInBin;blue=blue/pixelsInBin;for(x=xBinStart;x<xBinEnd;x+=1){if(x>=width){continue;}
for(y=yBinStart;y<yBinEnd;y+=1){if(y>=height){continue;}
i=(width*y+x)*4;imageData[i+0]=red;imageData[i+1]=green;imageData[i+2]=blue;imageData[i+3]=alpha;}}}}};Kinetic.Factory.addGetterSetter(Kinetic.Node,'pixelSize',8,null,Kinetic.Factory.afterSetFilter);})();;(function(){Kinetic.Filters.Threshold=function(imageData){var level=this.threshold()*255,data=imageData.data,len=data.length,i;for(i=0;i<len;i+=1){data[i]=data[i]<level?0:255;}};Kinetic.Factory.addGetterSetter(Kinetic.Node,'threshold',0.5,null,Kinetic.Factory.afterSetFilter);})();;(function(){Kinetic.Filters.Sepia=function(imageData){var data=imageData.data,w=imageData.width,y=imageData.height,w4=w*4,offsetY,x,offset,or,og,ob,r,g,b;do{offsetY=(y-1)*w4;x=w;do{offset=offsetY+(x-1)*4;or=data[offset];og=data[offset+1];ob=data[offset+2];r=or*0.393+og*0.769+ob*0.189;g=or*0.349+og*0.686+ob*0.168;b=or*0.272+og*0.534+ob*0.131;data[offset]=r>255?255:r;data[offset+1]=g>255?255:g;data[offset+2]=b>255?255:b;data[offset+3]=data[offset+3];}while(--x);}while(--y);};})();;(function(){Kinetic.Filters.Solarize=function(imageData){var data=imageData.data,w=imageData.width,h=imageData.height,w4=w*4,y=h;do{var offsetY=(y-1)*w4;var x=w;do{var offset=offsetY+(x-1)*4;var r=data[offset];var g=data[offset+1];var b=data[offset+2];if(r>127){r=255-r;}
if(g>127){g=255-g;}
if(b>127){b=255-b;}
data[offset]=r;data[offset+1]=g;data[offset+2]=b;}while(--x);}while(--y);};})();;(function(){var ToPolar=function(src,dst,opt){var srcPixels=src.data,dstPixels=dst.data,xSize=src.width,ySize=src.height,xMid=opt.polarCenterX||xSize/2,yMid=opt.polarCenterY||ySize/2,i,x,y,r=0,g=0,b=0,a=0;var rad,rMax=Math.sqrt(xMid*xMid+yMid*yMid);x=xSize-xMid;y=ySize-yMid;rad=Math.sqrt(x*x+y*y);rMax=(rad>rMax)?rad:rMax;var rSize=ySize,tSize=xSize,radius,theta;var conversion=360/tSize*Math.PI/180,sin,cos;for(theta=0;theta<tSize;theta+=1){sin=Math.sin(theta*conversion);cos=Math.cos(theta*conversion);for(radius=0;radius<rSize;radius+=1){x=Math.floor(xMid+rMax*radius/rSize*cos);y=Math.floor(yMid+rMax*radius/rSize*sin);i=(y*xSize+x)*4;r=srcPixels[i+0];g=srcPixels[i+1];b=srcPixels[i+2];a=srcPixels[i+3];i=(theta+radius*xSize)*4;dstPixels[i+0]=r;dstPixels[i+1]=g;dstPixels[i+2]=b;dstPixels[i+3]=a;}}};var FromPolar=function(src,dst,opt){var srcPixels=src.data,dstPixels=dst.data,xSize=src.width,ySize=src.height,xMid=opt.polarCenterX||xSize/2,yMid=opt.polarCenterY||ySize/2,i,x,y,dx,dy,r=0,g=0,b=0,a=0;var rad,rMax=Math.sqrt(xMid*xMid+yMid*yMid);x=xSize-xMid;y=ySize-yMid;rad=Math.sqrt(x*x+y*y);rMax=(rad>rMax)?rad:rMax;var rSize=ySize,tSize=xSize,radius,theta,phaseShift=opt.polarRotation||0;var x1,y1;for(x=0;x<xSize;x+=1){for(y=0;y<ySize;y+=1){dx=x-xMid;dy=y-yMid;radius=Math.sqrt(dx*dx+dy*dy)*rSize/rMax;theta=(Math.atan2(dy,dx)*180/Math.PI+360+phaseShift)%360;theta=theta*tSize/360;x1=Math.floor(theta);y1=Math.floor(radius);i=(y1*xSize+x1)*4;r=srcPixels[i+0];g=srcPixels[i+1];b=srcPixels[i+2];a=srcPixels[i+3];i=(y*xSize+x)*4;dstPixels[i+0]=r;dstPixels[i+1]=g;dstPixels[i+2]=b;dstPixels[i+3]=a;}}};var tempCanvas=Kinetic.Util.createCanvasElement();Kinetic.Filters.Kaleidoscope=function(imageData){var xSize=imageData.width,ySize=imageData.height;var x,y,xoff,i,r,g,b,a,srcPos,dstPos;var power=Math.round(this.kaleidoscopePower());var angle=Math.round(this.kaleidoscopeAngle());var offset=Math.floor(xSize*(angle%360)/360);if(power<1){return;}
tempCanvas.width=xSize;tempCanvas.height=ySize;var scratchData=tempCanvas.getContext('2d').getImageData(0,0,xSize,ySize);ToPolar(imageData,scratchData,{polarCenterX:xSize/2,polarCenterY:ySize/2});var minSectionSize=xSize/Math.pow(2,power);while(minSectionSize<=8){minSectionSize=minSectionSize*2;power-=1;}
minSectionSize=Math.ceil(minSectionSize);var sectionSize=minSectionSize;var xStart=0,xEnd=sectionSize,xDelta=1;if(offset+minSectionSize>xSize){xStart=sectionSize;xEnd=0;xDelta=-1;}
for(y=0;y<ySize;y+=1){for(x=xStart;x!==xEnd;x+=xDelta){xoff=Math.round(x+offset)%xSize;srcPos=(xSize*y+xoff)*4;r=scratchData.data[srcPos+0];g=scratchData.data[srcPos+1];b=scratchData.data[srcPos+2];a=scratchData.data[srcPos+3];dstPos=(xSize*y+x)*4;scratchData.data[dstPos+0]=r;scratchData.data[dstPos+1]=g;scratchData.data[dstPos+2]=b;scratchData.data[dstPos+3]=a;}}
for(y=0;y<ySize;y+=1){sectionSize=Math.floor(minSectionSize);for(i=0;i<power;i+=1){for(x=0;x<sectionSize+1;x+=1){srcPos=(xSize*y+x)*4;r=scratchData.data[srcPos+0];g=scratchData.data[srcPos+1];b=scratchData.data[srcPos+2];a=scratchData.data[srcPos+3];dstPos=(xSize*y+sectionSize*2-x-1)*4;scratchData.data[dstPos+0]=r;scratchData.data[dstPos+1]=g;scratchData.data[dstPos+2]=b;scratchData.data[dstPos+3]=a;}
sectionSize*=2;}}
FromPolar(scratchData,imageData,{polarRotation:0});};Kinetic.Factory.addGetterSetter(Kinetic.Node,'kaleidoscopePower',2,null,Kinetic.Factory.afterSetFilter);Kinetic.Factory.addGetterSetter(Kinetic.Node,'kaleidoscopeAngle',0,null,Kinetic.Factory.afterSetFilter);})();;(function(){var BATCH_DRAW_STOP_TIME_DIFF=500;var now=(function(){if(Kinetic.root.performance&&Kinetic.root.performance.now){return function(){return Kinetic.root.performance.now();};}
else{return function(){return new Date().getTime();};}})();var RAF=(function(){return Kinetic.root.requestAnimationFrame||Kinetic.root.webkitRequestAnimationFrame||Kinetic.root.mozRequestAnimationFrame||Kinetic.root.oRequestAnimationFrame||Kinetic.root.msRequestAnimationFrame||FRAF;})();function FRAF(callback){Kinetic.root.setTimeout(callback,1000/60);}
function requestAnimFrame(){return RAF.apply(Kinetic.root,arguments);}
Kinetic.Animation=function(func,layers){var Anim=Kinetic.Animation;this.func=func;this.setLayers(layers);this.id=Anim.animIdCounter++;this.frame={time:0,timeDiff:0,lastTime:now()};};Kinetic.Animation.prototype={setLayers:function(layers){var lays=[];if(!layers){lays=[];}
else if(layers.length>0){lays=layers;}
else{lays=[layers];}
this.layers=lays;},getLayers:function(){return this.layers;},addLayer:function(layer){var layers=this.layers,len,n;if(layers){len=layers.length;for(n=0;n<len;n++){if(layers[n]._id===layer._id){return false;}}}
else{this.layers=[];}
this.layers.push(layer);return true;},isRunning:function(){var a=Kinetic.Animation,animations=a.animations,len=animations.length,n;for(n=0;n<len;n++){if(animations[n].id===this.id){return true;}}
return false;},start:function(){var Anim=Kinetic.Animation;this.stop();this.frame.timeDiff=0;this.frame.lastTime=now();Anim._addAnimation(this);},stop:function(){Kinetic.Animation._removeAnimation(this);},_updateFrameObject:function(time){this.frame.timeDiff=time-this.frame.lastTime;this.frame.lastTime=time;this.frame.time+=this.frame.timeDiff;this.frame.frameRate=1000/this.frame.timeDiff;}};Kinetic.Animation.animations=[];Kinetic.Animation.animIdCounter=0;Kinetic.Animation.animRunning=false;Kinetic.Animation._addAnimation=function(anim){this.animations.push(anim);this._handleAnimation();};Kinetic.Animation._removeAnimation=function(anim){var id=anim.id,animations=this.animations,len=animations.length,n;for(n=0;n<len;n++){if(animations[n].id===id){this.animations.splice(n,1);break;}}};Kinetic.Animation._runFrames=function(){var layerHash={},animations=this.animations,anim,layers,func,n,i,layersLen,layer,key;for(n=0;n<animations.length;n++){anim=animations[n];layers=anim.layers;func=anim.func;anim._updateFrameObject(now());layersLen=layers.length;for(i=0;i<layersLen;i++){layer=layers[i];if(layer._id!==undefined){layerHash[layer._id]=layer;}}
if(func){func.call(anim,anim.frame);}}
for(key in layerHash){layerHash[key].draw();}};Kinetic.Animation._animationLoop=function(){var Anim=Kinetic.Animation;if(Anim.animations.length){requestAnimFrame(Anim._animationLoop);Anim._runFrames();}
else{Anim.animRunning=false;}};Kinetic.Animation._handleAnimation=function(){var that=this;if(!this.animRunning){this.animRunning=true;that._animationLoop();}};var moveTo=Kinetic.Node.prototype.moveTo;Kinetic.Node.prototype.moveTo=function(container){moveTo.call(this,container);};Kinetic.Layer.prototype.batchDraw=function(){var that=this,Anim=Kinetic.Animation;if(!this.batchAnim){this.batchAnim=new Anim(function(){if(that.lastBatchDrawTime&&now()-that.lastBatchDrawTime>BATCH_DRAW_STOP_TIME_DIFF){that.batchAnim.stop();}},this);}
this.lastBatchDrawTime=now();if(!this.batchAnim.isRunning()){this.draw();this.batchAnim.start();}};Kinetic.Stage.prototype.batchDraw=function(){this.getChildren().each(function(layer){layer.batchDraw();});};})((1,eval)('this'));;(function(){var blacklist={node:1,duration:1,easing:1,onFinish:1,yoyo:1},PAUSED=1,PLAYING=2,REVERSING=3,idCounter=0;Kinetic.Tween=function(config){var that=this,node=config.node,nodeId=node._id,duration=config.duration||1,easing=config.easing||Kinetic.Easings.Linear,yoyo=!!config.yoyo,key;this.node=node;this._id=idCounter++;this.anim=new Kinetic.Animation(function(){that.tween.onEnterFrame();},node.getLayer());this.tween=new Tween(key,function(i){that._tweenFunc(i);},easing,0,1,duration*1000,yoyo);this._addListeners();if(!Kinetic.Tween.attrs[nodeId]){Kinetic.Tween.attrs[nodeId]={};}
if(!Kinetic.Tween.attrs[nodeId][this._id]){Kinetic.Tween.attrs[nodeId][this._id]={};}
if(!Kinetic.Tween.tweens[nodeId]){Kinetic.Tween.tweens[nodeId]={};}
for(key in config){if(blacklist[key]===undefined){this._addAttr(key,config[key]);}}
this.reset();this.onFinish=config.onFinish;this.onReset=config.onReset;};Kinetic.Tween.attrs={};Kinetic.Tween.tweens={};Kinetic.Tween.prototype={_addAttr:function(key,end){var node=this.node,nodeId=node._id,start,diff,tweenId,n,len;tweenId=Kinetic.Tween.tweens[nodeId][key];if(tweenId){delete Kinetic.Tween.attrs[nodeId][tweenId][key];}
start=node.getAttr(key);if(Kinetic.Util._isArray(end)){diff=[];len=end.length;for(n=0;n<len;n++){diff.push(end[n]-start[n]);}}
else{diff=end-start;}
Kinetic.Tween.attrs[nodeId][this._id][key]={start:start,diff:diff};Kinetic.Tween.tweens[nodeId][key]=this._id;},_tweenFunc:function(i){var node=this.node,attrs=Kinetic.Tween.attrs[node._id][this._id],key,attr,start,diff,newVal,n,len;for(key in attrs){attr=attrs[key];start=attr.start;diff=attr.diff;if(Kinetic.Util._isArray(start)){newVal=[];len=start.length;for(n=0;n<len;n++){newVal.push(start[n]+(diff[n]*i));}}
else{newVal=start+(diff*i);}
node.setAttr(key,newVal);}},_addListeners:function(){var that=this;this.tween.onPlay=function(){that.anim.start();};this.tween.onReverse=function(){that.anim.start();};this.tween.onPause=function(){that.anim.stop();};this.tween.onFinish=function(){if(that.onFinish){that.onFinish();}};this.tween.onReset=function(){if(that.onReset){that.onReset();}};},play:function(){this.tween.play();return this;},reverse:function(){this.tween.reverse();return this;},reset:function(){var node=this.node;this.tween.reset();return this;},seek:function(t){var node=this.node;this.tween.seek(t*1000);return this;},pause:function(){this.tween.pause();return this;},finish:function(){var node=this.node;this.tween.finish();return this;},destroy:function(){var nodeId=this.node._id,thisId=this._id,attrs=Kinetic.Tween.tweens[nodeId],key;this.pause();for(key in attrs){delete Kinetic.Tween.tweens[nodeId][key];}
delete Kinetic.Tween.attrs[nodeId][thisId];}};var Tween=function(prop,propFunc,func,begin,finish,duration,yoyo){this.prop=prop;this.propFunc=propFunc;this.begin=begin;this._pos=begin;this.duration=duration;this._change=0;this.prevPos=0;this.yoyo=yoyo;this._time=0;this._position=0;this._startTime=0;this._finish=0;this.func=func;this._change=finish-this.begin;this.pause();};Tween.prototype={fire:function(str){var handler=this[str];if(handler){handler();}},setTime:function(t){if(t>this.duration){if(this.yoyo){this._time=this.duration;this.reverse();}
else{this.finish();}}
else if(t<0){if(this.yoyo){this._time=0;this.play();}
else{this.reset();}}
else{this._time=t;this.update();}},getTime:function(){return this._time;},setPosition:function(p){this.prevPos=this._pos;this.propFunc(p);this._pos=p;},getPosition:function(t){if(t===undefined){t=this._time;}
return this.func(t,this.begin,this._change,this.duration);},play:function(){this.state=PLAYING;this._startTime=this.getTimer()-this._time;this.onEnterFrame();this.fire('onPlay');},reverse:function(){this.state=REVERSING;this._time=this.duration-this._time;this._startTime=this.getTimer()-this._time;this.onEnterFrame();this.fire('onReverse');},seek:function(t){this.pause();this._time=t;this.update();this.fire('onSeek');},reset:function(){this.pause();this._time=0;this.update();this.fire('onReset');},finish:function(){this.pause();this._time=this.duration;this.update();this.fire('onFinish');},update:function(){this.setPosition(this.getPosition(this._time));},onEnterFrame:function(){var t=this.getTimer()-this._startTime;if(this.state===PLAYING){this.setTime(t);}
else if(this.state===REVERSING){this.setTime(this.duration-t);}},pause:function(){this.state=PAUSED;this.fire('onPause');},getTimer:function(){return new Date().getTime();}};Kinetic.Easings={'BackEaseIn':function(t,b,c,d){var s=1.70158;return c*(t/=d)*t*((s+1)*t-s)+b;},'BackEaseOut':function(t,b,c,d){var s=1.70158;return c*((t=t/d-1)*t*((s+1)*t+s)+1)+b;},'BackEaseInOut':function(t,b,c,d){var s=1.70158;if((t/=d/2)<1){return c/2*(t*t*(((s*=(1.525))+1)*t-s))+b;}
return c/2*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2)+b;},'ElasticEaseIn':function(t,b,c,d,a,p){var s=0;if(t===0){return b;}
if((t/=d)==1){return b+c;}
if(!p){p=d*0.3;}
if(!a||a<Math.abs(c)){a=c;s=p/4;}
else{s=p/(2*Math.PI)*Math.asin(c/a);}
return-(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;},'ElasticEaseOut':function(t,b,c,d,a,p){var s=0;if(t===0){return b;}
if((t/=d)==1){return b+c;}
if(!p){p=d*0.3;}
if(!a||a<Math.abs(c)){a=c;s=p/4;}
else{s=p/(2*Math.PI)*Math.asin(c/a);}
return(a*Math.pow(2,-10*t)*Math.sin((t*d-s)*(2*Math.PI)/p)+c+b);},'ElasticEaseInOut':function(t,b,c,d,a,p){var s=0;if(t===0){return b;}
if((t/=d/2)==2){return b+c;}
if(!p){p=d*(0.3*1.5);}
if(!a||a<Math.abs(c)){a=c;s=p/4;}
else{s=p/(2*Math.PI)*Math.asin(c/a);}
if(t<1){return-0.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;}
return a*Math.pow(2,-10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p)*0.5+c+b;},'BounceEaseOut':function(t,b,c,d){if((t/=d)<(1/2.75)){return c*(7.5625*t*t)+b;}
else if(t<(2/2.75)){return c*(7.5625*(t-=(1.5/2.75))*t+0.75)+b;}
else if(t<(2.5/2.75)){return c*(7.5625*(t-=(2.25/2.75))*t+0.9375)+b;}
else{return c*(7.5625*(t-=(2.625/2.75))*t+0.984375)+b;}},'BounceEaseIn':function(t,b,c,d){return c-Kinetic.Easings.BounceEaseOut(d-t,0,c,d)+b;},'BounceEaseInOut':function(t,b,c,d){if(t<d/2){return Kinetic.Easings.BounceEaseIn(t*2,0,c,d)*0.5+b;}
else{return Kinetic.Easings.BounceEaseOut(t*2-d,0,c,d)*0.5+c*0.5+b;}},'EaseIn':function(t,b,c,d){return c*(t/=d)*t+b;},'EaseOut':function(t,b,c,d){return-c*(t/=d)*(t-2)+b;},'EaseInOut':function(t,b,c,d){if((t/=d/2)<1){return c/2*t*t+b;}
return-c/2*((--t)*(t-2)-1)+b;},'StrongEaseIn':function(t,b,c,d){return c*(t/=d)*t*t*t*t+b;},'StrongEaseOut':function(t,b,c,d){return c*((t=t/d-1)*t*t*t*t+1)+b;},'StrongEaseInOut':function(t,b,c,d){if((t/=d/2)<1){return c/2*t*t*t*t*t+b;}
return c/2*((t-=2)*t*t*t*t+2)+b;},'Linear':function(t,b,c,d){return c*t/d+b;}};})();;(function(){Kinetic.DD={anim:new Kinetic.Animation(),isDragging:false,offset:{x:0,y:0},node:null,_drag:function(evt){var dd=Kinetic.DD,node=dd.node;if(node){if(!dd.isDragging){var pos=node.getStage().getPointerPosition();var dragDistance=node.dragDistance();var distance=Math.max(Math.abs(pos.x-dd.startPointerPos.x),Math.abs(pos.y-dd.startPointerPos.y));if(distance<dragDistance){return;}}
node._setDragPosition(evt);if(!dd.isDragging){dd.isDragging=true;node.fire('dragstart',{type:'dragstart',target:node,evt:evt},true);}
node.fire('dragmove',{type:'dragmove',target:node,evt:evt},true);}},_endDragBefore:function(evt){var dd=Kinetic.DD,node=dd.node,nodeType,layer;if(node){nodeType=node.nodeType;layer=node.getLayer();dd.anim.stop();if(dd.isDragging){dd.isDragging=false;Kinetic.listenClickTap=false;if(evt){evt.dragEndNode=node;}}
delete dd.node;(layer||node).draw();}},_endDragAfter:function(evt){evt=evt||{};var dragEndNode=evt.dragEndNode;if(evt&&dragEndNode){dragEndNode.fire('dragend',{type:'dragend',target:dragEndNode,evt:evt},true);}}};Kinetic.Node.prototype.startDrag=function(){var dd=Kinetic.DD,stage=this.getStage(),layer=this.getLayer(),pos=stage.getPointerPosition(),ap=this.getAbsolutePosition();if(pos){if(dd.node){dd.node.stopDrag();}
dd.node=this;dd.startPointerPos=pos;dd.offset.x=pos.x-ap.x;dd.offset.y=pos.y-ap.y;dd.anim.setLayers(layer||this.getLayers());dd.anim.start();this._setDragPosition();}};Kinetic.Node.prototype._setDragPosition=function(evt){var dd=Kinetic.DD,pos=this.getStage().getPointerPosition(),dbf=this.getDragBoundFunc();if(!pos){return;}
var newNodePos={x:pos.x-dd.offset.x,y:pos.y-dd.offset.y};if(dbf!==undefined){newNodePos=dbf.call(this,newNodePos,evt);}
this.setAbsolutePosition(newNodePos);};Kinetic.Node.prototype.stopDrag=function(){var dd=Kinetic.DD,evt={};dd._endDragBefore(evt);dd._endDragAfter(evt);};Kinetic.Node.prototype.setDraggable=function(draggable){this._setAttr('draggable',draggable);this._dragChange();};var origDestroy=Kinetic.Node.prototype.destroy;Kinetic.Node.prototype.destroy=function(){var dd=Kinetic.DD;if(dd.node&&dd.node._id===this._id){this.stopDrag();}
origDestroy.call(this);};Kinetic.Node.prototype.isDragging=function(){var dd=Kinetic.DD;return dd.node&&dd.node._id===this._id&&dd.isDragging;};Kinetic.Node.prototype._listenDrag=function(){var that=this;this._dragCleanup();if(this.getClassName()==='Stage'){this.on('contentMousedown.kinetic contentTouchstart.kinetic',function(evt){if(!Kinetic.DD.node){that.startDrag(evt);}});}
else{this.on('mousedown.kinetic touchstart.kinetic',function(evt){if(!Kinetic.DD.node){that.startDrag(evt);}});}
};Kinetic.Node.prototype._dragChange=function(){if(this.attrs.draggable){this._listenDrag();}
else{this._dragCleanup();var stage=this.getStage();var dd=Kinetic.DD;if(stage&&dd.node&&dd.node._id===this._id){dd.node.stopDrag();}}};Kinetic.Node.prototype._dragCleanup=function(){if(this.getClassName()==='Stage'){this.off('contentMousedown.kinetic');this.off('contentTouchstart.kinetic');}else{this.off('mousedown.kinetic');this.off('touchstart.kinetic');}};Kinetic.Factory.addGetterSetter(Kinetic.Node,'dragBoundFunc');Kinetic.Factory.addGetter(Kinetic.Node,'draggable',false);Kinetic.Factory.addOverloadedGetterSetter(Kinetic.Node,'draggable');var html=Kinetic.document.documentElement;html.addEventListener('mouseup',Kinetic.DD._endDragBefore,true);html.addEventListener('touchend',Kinetic.DD._endDragBefore,true);html.addEventListener('mouseup',Kinetic.DD._endDragAfter,false);html.addEventListener('touchend',Kinetic.DD._endDragAfter,false);})();;(function(){Kinetic.Util.addMethods(Kinetic.Container,{__init:function(config){this.children=new Kinetic.Collection();Kinetic.Node.call(this,config);},getChildren:function(predicate){if(!predicate){return this.children;}else{var results=new Kinetic.Collection();this.children.each(function(child){if(predicate(child)){results.push(child);}});return results;}},hasChildren:function(){return this.getChildren().length>0;},removeChildren:function(){var children=Kinetic.Collection.toCollection(this.children);var child;for(var i=0;i<children.length;i++){child=children[i];delete child.parent;child.index=0;if(child.hasChildren()){child.removeChildren();}
child.remove();}
children=null;this.children=new Kinetic.Collection();return this;},destroyChildren:function(){var children=Kinetic.Collection.toCollection(this.children);var child;for(var i=0;i<children.length;i++){child=children[i];delete child.parent;child.index=0;child.destroy();}
children=null;this.children=new Kinetic.Collection();return this;},add:function(child){if(arguments.length>1){for(var i=0;i<arguments.length;i++){this.add(arguments[i]);}
return;}
if(child.getParent()){child.moveTo(this);return;}
var children=this.children;this._validateAdd(child);child.index=children.length;child.parent=this;children.push(child);this._fire('add',{child:child});return this;},destroy:function(){if(this.hasChildren()){this.destroyChildren();}
Kinetic.Node.prototype.destroy.call(this);},find:function(selector){var retArr=[],selectorArr=selector.replace(/ /g,'').split(','),len=selectorArr.length,n,i,sel,arr,node,children,clen;for(n=0;n<len;n++){sel=selectorArr[n];if(sel.charAt(0)==='#'){node=this._getNodeById(sel.slice(1));if(node){retArr.push(node);}}
else if(sel.charAt(0)==='.'){arr=this._getNodesByName(sel.slice(1));retArr=retArr.concat(arr);}
else{children=this.getChildren();clen=children.length;for(i=0;i<clen;i++){retArr=retArr.concat(children[i]._get(sel));}}}
return Kinetic.Collection.toCollection(retArr);},_getNodeById:function(key){var node=Kinetic.ids[key];if(node!==undefined&&this.isAncestorOf(node)){return node;}
return null;},_getNodesByName:function(key){var arr=Kinetic.names[key]||[];return this._getDescendants(arr);},_get:function(selector){var retArr=Kinetic.Node.prototype._get.call(this,selector);var children=this.getChildren();var len=children.length;for(var n=0;n<len;n++){retArr=retArr.concat(children[n]._get(selector));}
return retArr;},toObject:function(){var obj=Kinetic.Node.prototype.toObject.call(this);obj.children=[];var children=this.getChildren();var len=children.length;for(var n=0;n<len;n++){var child=children[n];obj.children.push(child.toObject());}
return obj;},_getDescendants:function(arr){var retArr=[];var len=arr.length;for(var n=0;n<len;n++){var node=arr[n];if(this.isAncestorOf(node)){retArr.push(node);}}
return retArr;},isAncestorOf:function(node){var parent=node.getParent();while(parent){if(parent._id===this._id){return true;}
parent=parent.getParent();}
return false;},clone:function(obj){var node=Kinetic.Node.prototype.clone.call(this,obj);this.getChildren().each(function(no){node.add(no.clone());});return node;},getAllIntersections:function(pos){var arr=[];this.find('Shape').each(function(shape){if(shape.isVisible()&&shape.intersects(pos)){arr.push(shape);}});return arr;},_setChildrenIndices:function(){this.children.each(function(child,n){child.index=n;});},drawScene:function(can,top){var layer=this.getLayer(),canvas=can||(layer&&layer.getCanvas()),context=canvas&&canvas.getContext(),cachedCanvas=this._cache.canvas,cachedSceneCanvas=cachedCanvas&&cachedCanvas.scene;if(this.isVisible()){if(cachedSceneCanvas){this._drawCachedSceneCanvas(context);}
else{this._drawChildren(canvas,'drawScene',top);}}
return this;},drawHit:function(can,top){var layer=this.getLayer(),canvas=can||(layer&&layer.hitCanvas),context=canvas&&canvas.getContext(),cachedCanvas=this._cache.canvas,cachedHitCanvas=cachedCanvas&&cachedCanvas.hit;if(this.shouldDrawHit()){if(cachedHitCanvas){this._drawCachedHitCanvas(context);}
else{this._drawChildren(canvas,'drawHit',top);}}
return this;},_drawChildren:function(canvas,drawMethod,top){var layer=this.getLayer(),context=canvas&&canvas.getContext(),clipWidth=this.getClipWidth(),clipHeight=this.getClipHeight(),hasClip=clipWidth&&clipHeight,clipX,clipY;if(hasClip&&layer){clipX=this.getClipX();clipY=this.getClipY();context.save();layer._applyTransform(this,context);context.beginPath();context.rect(clipX,clipY,clipWidth,clipHeight);context.clip();context.reset();}
this.children.each(function(child){child[drawMethod](canvas,top);});if(hasClip){context.restore();}}});Kinetic.Util.extend(Kinetic.Container,Kinetic.Node);Kinetic.Container.prototype.get=Kinetic.Container.prototype.find;Kinetic.Factory.addComponentsGetterSetter(Kinetic.Container,'clip',['x','y','width','height']);Kinetic.Factory.addGetterSetter(Kinetic.Container,'clipX');Kinetic.Factory.addGetterSetter(Kinetic.Container,'clipY');Kinetic.Factory.addGetterSetter(Kinetic.Container,'clipWidth');Kinetic.Factory.addGetterSetter(Kinetic.Container,'clipHeight');Kinetic.Collection.mapMethods(Kinetic.Container);})();;(function(){var HAS_SHADOW='hasShadow';function _fillFunc(context){context.fill();}
function _strokeFunc(context){context.stroke();}
function _fillFuncHit(context){context.fill();}
function _strokeFuncHit(context){context.stroke();}
function _clearHasShadowCache(){this._clearCache(HAS_SHADOW);}
Kinetic.Util.addMethods(Kinetic.Shape,{__init:function(config){this.nodeType='Shape';this._fillFunc=_fillFunc;this._strokeFunc=_strokeFunc;this._fillFuncHit=_fillFuncHit;this._strokeFuncHit=_strokeFuncHit;var shapes=Kinetic.shapes;var key;while(true){key=Kinetic.Util.getRandomColor();if(key&&!(key in shapes)){break;}}
this.colorKey=key;shapes[key]=this;Kinetic.Node.call(this,config);this.on('shadowColorChange.kinetic shadowBlurChange.kinetic shadowOffsetChange.kinetic shadowOpacityChange.kinetic shadowEnabledChange.kinetic',_clearHasShadowCache);},hasChildren:function(){return false;},getChildren:function(){return[];},getContext:function(){return this.getLayer().getContext();},getCanvas:function(){return this.getLayer().getCanvas();},hasShadow:function(){return this._getCache(HAS_SHADOW,this._hasShadow);},_hasShadow:function(){return this.getShadowEnabled()&&(this.getShadowOpacity()!==0&&!!(this.getShadowColor()||this.getShadowBlur()||this.getShadowOffsetX()||this.getShadowOffsetY()));},hasFill:function(){return!!(this.getFill()||this.getFillPatternImage()||this.getFillLinearGradientColorStops()||this.getFillRadialGradientColorStops());},hasStroke:function(){return!!(this.stroke()||this.strokeRed()||this.strokeGreen()||this.strokeBlue());},_get:function(selector){return this.className===selector||this.nodeType===selector?[this]:[];},intersects:function(pos){var stage=this.getStage(),bufferHitCanvas=stage.bufferHitCanvas,p;bufferHitCanvas.getContext().clear();this.drawScene(bufferHitCanvas);p=bufferHitCanvas.context.getImageData(Math.round(pos.x),Math.round(pos.y),1,1).data;return p[3]>0;},destroy:function(){Kinetic.Node.prototype.destroy.call(this);delete Kinetic.shapes[this.colorKey];},_useBufferCanvas:function(){return(this.hasShadow()||this.getAbsoluteOpacity()!==1)&&this.hasFill()&&this.hasStroke()&&this.getStage();},drawScene:function(can,top){var layer=this.getLayer(),canvas=can||layer.getCanvas(),context=canvas.getContext(),cachedCanvas=this._cache.canvas,drawFunc=this.sceneFunc(),hasShadow=this.hasShadow(),stage,bufferCanvas,bufferContext;if(this.isVisible()){if(cachedCanvas){this._drawCachedSceneCanvas(context);}
else if(drawFunc){context.save();if(this._useBufferCanvas()){stage=this.getStage();bufferCanvas=stage.bufferCanvas;bufferContext=bufferCanvas.getContext();bufferContext.clear();bufferContext.save();bufferContext._applyLineJoin(this);layer._applyTransform(this,bufferContext,top);drawFunc.call(this,bufferContext);bufferContext.restore();if(hasShadow){context.save();context._applyShadow(this);context.drawImage(bufferCanvas._canvas,0,0);context.restore();}
context._applyOpacity(this);context.drawImage(bufferCanvas._canvas,0,0);}
else{context._applyLineJoin(this);layer._applyTransform(this,context,top);if(hasShadow){context.save();context._applyShadow(this);drawFunc.call(this,context);context.restore();}
context._applyOpacity(this);drawFunc.call(this,context);}
context.restore();}}
return this;},drawHit:function(can,top){var layer=this.getLayer(),canvas=can||layer.hitCanvas,context=canvas.getContext(),drawFunc=this.hitFunc()||this.sceneFunc(),cachedCanvas=this._cache.canvas,cachedHitCanvas=cachedCanvas&&cachedCanvas.hit;if(this.shouldDrawHit()){if(cachedHitCanvas){this._drawCachedHitCanvas(context);}
else if(drawFunc){context.save();context._applyLineJoin(this);layer._applyTransform(this,context,top);drawFunc.call(this,context);context.restore();}}
return this;},drawHitFromCache:function(alphaThreshold){var threshold=alphaThreshold||0,cachedCanvas=this._cache.canvas,sceneCanvas=this._getCachedSceneCanvas(),sceneContext=sceneCanvas.getContext(),hitCanvas=cachedCanvas.hit,hitContext=hitCanvas.getContext(),width=sceneCanvas.getWidth(),height=sceneCanvas.getHeight(),sceneImageData,sceneData,hitImageData,hitData,len,rgbColorKey,i,alpha;hitContext.clear();try{sceneImageData=sceneContext.getImageData(0,0,width,height);sceneData=sceneImageData.data;hitImageData=hitContext.getImageData(0,0,width,height);hitData=hitImageData.data;len=sceneData.length;rgbColorKey=Kinetic.Util._hexToRgb(this.colorKey);for(i=0;i<len;i+=4){alpha=sceneData[i+3];if(alpha>threshold){hitData[i]=rgbColorKey.r;hitData[i+1]=rgbColorKey.g;hitData[i+2]=rgbColorKey.b;hitData[i+3]=255;}}
hitContext.putImageData(hitImageData,0,0);}
catch(e){Kinetic.Util.warn('Unable to draw hit graph from cached scene canvas. '+e.message);}
return this;},});Kinetic.Util.extend(Kinetic.Shape,Kinetic.Node);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'stroke');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'strokeRed',0,Kinetic.Validators.RGBComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'strokeGreen',0,Kinetic.Validators.RGBComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'strokeBlue',0,Kinetic.Validators.RGBComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'strokeAlpha',1,Kinetic.Validators.alphaComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'strokeWidth',2);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'lineJoin');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'lineCap');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'sceneFunc');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'hitFunc');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'dash');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'shadowColor');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'shadowRed',0,Kinetic.Validators.RGBComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'shadowGreen',0,Kinetic.Validators.RGBComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'shadowBlue',0,Kinetic.Validators.RGBComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'shadowAlpha',1,Kinetic.Validators.alphaComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'shadowBlur');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'shadowOpacity');Kinetic.Factory.addComponentsGetterSetter(Kinetic.Shape,'shadowOffset',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'shadowOffsetX',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'shadowOffsetY',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillPatternImage');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fill');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillRed',0,Kinetic.Validators.RGBComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillGreen',0,Kinetic.Validators.RGBComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillBlue',0,Kinetic.Validators.RGBComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillAlpha',1,Kinetic.Validators.alphaComponent);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillPatternX',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillPatternY',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillLinearGradientColorStops');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillRadialGradientStartRadius',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillRadialGradientEndRadius',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillRadialGradientColorStops');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillPatternRepeat','repeat');Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillEnabled',true);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'strokeEnabled',true);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'shadowEnabled',true);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'dashEnabled',true);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'strokeScaleEnabled',true);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillPriority','color');Kinetic.Factory.addComponentsGetterSetter(Kinetic.Shape,'fillPatternOffset',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillPatternOffsetX',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillPatternOffsetY',0);Kinetic.Factory.addComponentsGetterSetter(Kinetic.Shape,'fillPatternScale',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillPatternScaleX',1);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillPatternScaleY',1);Kinetic.Factory.addComponentsGetterSetter(Kinetic.Shape,'fillLinearGradientStartPoint',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillLinearGradientStartPointX',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillLinearGradientStartPointY',0);Kinetic.Factory.addComponentsGetterSetter(Kinetic.Shape,'fillLinearGradientEndPoint',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillLinearGradientEndPointX',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillLinearGradientEndPointY',0);Kinetic.Factory.addComponentsGetterSetter(Kinetic.Shape,'fillRadialGradientStartPoint',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillRadialGradientStartPointX',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillRadialGradientStartPointY',0);Kinetic.Factory.addComponentsGetterSetter(Kinetic.Shape,'fillRadialGradientEndPoint',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillRadialGradientEndPointX',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillRadialGradientEndPointY',0);Kinetic.Factory.addGetterSetter(Kinetic.Shape,'fillPatternRotation',0);Kinetic.Factory.backCompat(Kinetic.Shape,{dashArray:'dash',getDashArray:'getDash',setDashArray:'getDash',drawFunc:'sceneFunc',getDrawFunc:'getSceneFunc',setDrawFunc:'setSceneFunc',drawHitFunc:'hitFunc',getDrawHitFunc:'getHitFunc',setDrawHitFunc:'setHitFunc'});Kinetic.Collection.mapMethods(Kinetic.Shape);})();;(function(){var STAGE='Stage',STRING='string',PX='px',MOUSEOUT='mouseout',MOUSELEAVE='mouseleave',MOUSEOVER='mouseover',MOUSEENTER='mouseenter',MOUSEMOVE='mousemove',MOUSEDOWN='mousedown',MOUSEUP='mouseup',CLICK='click',DBL_CLICK='dblclick',TOUCHSTART='touchstart',TOUCHEND='touchend',TAP='tap',DBL_TAP='dbltap',TOUCHMOVE='touchmove',CONTENT_MOUSEOUT='contentMouseout',CONTENT_MOUSELEAVE='contentMouseleave',CONTENT_MOUSEOVER='contentMouseover',CONTENT_MOUSEENTER='contentMouseenter',CONTENT_MOUSEMOVE='contentMousemove',CONTENT_MOUSEDOWN='contentMousedown',CONTENT_MOUSEUP='contentMouseup',CONTENT_CLICK='contentClick',CONTENT_DBL_CLICK='contentDblclick',CONTENT_TOUCHSTART='contentTouchstart',CONTENT_TOUCHEND='contentTouchend',CONTENT_TAP='contentTap',CONTENT_DBL_TAP='contentDbltap',CONTENT_TOUCHMOVE='contentTouchmove',DIV='div',RELATIVE='relative',INLINE_BLOCK='inline-block',KINETICJS_CONTENT='kineticjs-content',SPACE=' ',UNDERSCORE='_',CONTAINER='container',EMPTY_STRING='',EVENTS=[MOUSEDOWN,MOUSEMOVE,MOUSEUP,MOUSEOUT,TOUCHSTART,TOUCHMOVE,TOUCHEND,MOUSEOVER],eventsLength=EVENTS.length;function addEvent(ctx,eventName){ctx.content.addEventListener(eventName,function(evt){ctx[UNDERSCORE+eventName](evt);},false);}
Kinetic.Util.addMethods(Kinetic.Stage,{___init:function(config){this.nodeType=STAGE;Kinetic.Container.call(this,config);this._id=Kinetic.idCounter++;this._buildDOM();this._bindContentEvents();this._enableNestedTransforms=false;Kinetic.stages.push(this);},_validateAdd:function(child){if(child.getType()!=='Layer'){Kinetic.Util.error('You may only add layers to the stage.');}},setContainer:function(container){if(typeof container===STRING){var id=container;container=Kinetic.document.getElementById(container);if(!container){throw'Can not find container in document with id '+id;}}
this._setAttr(CONTAINER,container);return this;},shouldDrawHit:function(){return true;},draw:function(){Kinetic.Node.prototype.draw.call(this);return this;},setHeight:function(height){Kinetic.Node.prototype.setHeight.call(this,height);this._resizeDOM();return this;},setWidth:function(width){Kinetic.Node.prototype.setWidth.call(this,width);this._resizeDOM();return this;},clear:function(){var layers=this.children,len=layers.length,n;for(n=0;n<len;n++){layers[n].clear();}
return this;},clone:function(obj){if(!obj){obj={};}
obj.container=Kinetic.document.createElement(DIV);return Kinetic.Container.prototype.clone.call(this,obj);},destroy:function(){var content=this.content;Kinetic.Container.prototype.destroy.call(this);if(content&&Kinetic.Util._isInDocument(content)){this.getContainer().removeChild(content);}
var index=Kinetic.stages.indexOf(this);if(index>-1){Kinetic.stages.splice(index,1);}},getPointerPosition:function(){return this.pointerPos;},getStage:function(){return this;},getContent:function(){return this.content;},toDataURL:function(config){config=config||{};var mimeType=config.mimeType||null,quality=config.quality||null,x=config.x||0,y=config.y||0,canvas=new Kinetic.SceneCanvas({width:config.width||this.getWidth(),height:config.height||this.getHeight(),pixelRatio:1}),_context=canvas.getContext()._context,layers=this.children;if(x||y){_context.translate(-1*x,-1*y);}
function drawLayer(n){var layer=layers[n],layerUrl=layer.toDataURL(),imageObj=new Kinetic.window.Image();imageObj.onload=function(){_context.drawImage(imageObj,0,0);if(n<layers.length-1){drawLayer(n+1);}
else{config.callback(canvas.toDataURL(mimeType,quality));}};imageObj.src=layerUrl;}
drawLayer(0);},toImage:function(config){var cb=config.callback;config.callback=function(dataUrl){Kinetic.Util._getImage(dataUrl,function(img){cb(img);});};this.toDataURL(config);},getIntersection:function(pos){var layers=this.getChildren(),len=layers.length,end=len-1,n,shape;for(n=end;n>=0;n--){shape=layers[n].getIntersection(pos);if(shape){return shape;}}
return null;},_resizeDOM:function(){if(this.content){var width=this.getWidth(),height=this.getHeight(),layers=this.getChildren(),len=layers.length,n,layer;this.content.style.width=width+PX;this.content.style.height=height+PX;this.bufferCanvas.setSize(width,height);this.bufferHitCanvas.setSize(width,height);for(n=0;n<len;n++){layer=layers[n];layer.getCanvas().setSize(width,height);layer.hitCanvas.setSize(width,height);layer.draw();}}},add:function(layer){if(arguments.length>1){for(var i=0;i<arguments.length;i++){this.add(arguments[i]);}
return;}
Kinetic.Container.prototype.add.call(this,layer);layer._setCanvasSize(this.width(),this.height());layer.draw();this.content.appendChild(layer.canvas._canvas);return this;},getParent:function(){return null;},getLayer:function(){return null;},getLayers:function(){return this.getChildren();},_bindContentEvents:function(){for(var n=0;n<eventsLength;n++){addEvent(this,EVENTS[n]);}},_mouseover:function(evt){if(!Kinetic.UA.mobile){this._setPointerPosition(evt);this._fire(CONTENT_MOUSEOVER,{evt:evt});}},_mouseout:function(evt){if(!Kinetic.UA.mobile){this._setPointerPosition(evt);var targetShape=this.targetShape;if(targetShape&&!Kinetic.isDragging()){targetShape._fireAndBubble(MOUSEOUT,{evt:evt});targetShape._fireAndBubble(MOUSELEAVE,{evt:evt});this.targetShape=null;}
this.pointerPos=undefined;this._fire(CONTENT_MOUSEOUT,{evt:evt});}},_mousemove:function(evt){if(!Kinetic.UA.mobile){this._setPointerPosition(evt);var dd=Kinetic.DD,shape=this.getIntersection(this.getPointerPosition());if(shape&&shape.isListening()){if(!Kinetic.isDragging()&&(!this.targetShape||this.targetShape._id!==shape._id)){if(this.targetShape){this.targetShape._fireAndBubble(MOUSEOUT,{evt:evt},shape);this.targetShape._fireAndBubble(MOUSELEAVE,{evt:evt},shape);}
shape._fireAndBubble(MOUSEOVER,{evt:evt},this.targetShape);shape._fireAndBubble(MOUSEENTER,{evt:evt},this.targetShape);this.targetShape=shape;}
else{shape._fireAndBubble(MOUSEMOVE,{evt:evt});}}
else{if(this.targetShape&&!Kinetic.isDragging()){this.targetShape._fireAndBubble(MOUSEOUT,{evt:evt});this.targetShape._fireAndBubble(MOUSELEAVE,{evt:evt});this.targetShape=null;}}
this._fire(CONTENT_MOUSEMOVE,{evt:evt});if(dd){dd._drag(evt);}}
if(evt.preventDefault){evt.preventDefault();}},_mousedown:function(evt){if(!Kinetic.UA.mobile){this._setPointerPosition(evt);var shape=this.getIntersection(this.getPointerPosition());Kinetic.listenClickTap=true;if(shape&&shape.isListening()){this.clickStartShape=shape;shape._fireAndBubble(MOUSEDOWN,{evt:evt});}
this._fire(CONTENT_MOUSEDOWN,{evt:evt});}
if(evt.preventDefault){evt.preventDefault();}},_mouseup:function(evt){if(!Kinetic.UA.mobile){this._setPointerPosition(evt);var that=this,shape=this.getIntersection(this.getPointerPosition()),clickStartShape=this.clickStartShape,fireDblClick=false;if(Kinetic.inDblClickWindow){fireDblClick=true;Kinetic.inDblClickWindow=false;}
else{Kinetic.inDblClickWindow=true;}
setTimeout(function(){Kinetic.inDblClickWindow=false;},Kinetic.dblClickWindow);if(shape&&shape.isListening()){shape._fireAndBubble(MOUSEUP,{evt:evt});if(Kinetic.listenClickTap&&clickStartShape&&clickStartShape._id===shape._id){shape._fireAndBubble(CLICK,{evt:evt});if(fireDblClick){shape._fireAndBubble(DBL_CLICK,{evt:evt});}}}
this._fire(CONTENT_MOUSEUP,{evt:evt});if(Kinetic.listenClickTap){this._fire(CONTENT_CLICK,{evt:evt});if(fireDblClick){this._fire(CONTENT_DBL_CLICK,{evt:evt});}}
Kinetic.listenClickTap=false;}
if(evt.preventDefault){evt.preventDefault();}},_touchstart:function(evt){this._setPointerPosition(evt);var shape=this.getIntersection(this.getPointerPosition());Kinetic.listenClickTap=true;if(shape&&shape.isListening()){this.tapStartShape=shape;shape._fireAndBubble(TOUCHSTART,{evt:evt});if(shape.isListening()&&evt.preventDefault){evt.preventDefault();}}
this._fire(CONTENT_TOUCHSTART,{evt:evt});},_touchend:function(evt){this._setPointerPosition(evt);var shape=this.getIntersection(this.getPointerPosition()),fireDblClick=false;if(Kinetic.inDblClickWindow){fireDblClick=true;Kinetic.inDblClickWindow=false;}
else{Kinetic.inDblClickWindow=true;}
setTimeout(function(){Kinetic.inDblClickWindow=false;},Kinetic.dblClickWindow);if(shape&&shape.isListening()){shape._fireAndBubble(TOUCHEND,{evt:evt});if(Kinetic.listenClickTap&&shape._id===this.tapStartShape._id){shape._fireAndBubble(TAP,{evt:evt});if(fireDblClick){shape._fireAndBubble(DBL_TAP,{evt:evt});}}
if(shape.isListening()&&evt.preventDefault){evt.preventDefault();}}
if(Kinetic.listenClickTap){this._fire(CONTENT_TOUCHEND,{evt:evt});if(fireDblClick){this._fire(CONTENT_DBL_TAP,{evt:evt});}}
Kinetic.listenClickTap=false;},_touchmove:function(evt){this._setPointerPosition(evt);var dd=Kinetic.DD,shape=this.getIntersection(this.getPointerPosition());if(shape&&shape.isListening()){shape._fireAndBubble(TOUCHMOVE,{evt:evt});if(shape.isListening()&&evt.preventDefault){evt.preventDefault();}}
this._fire(CONTENT_TOUCHMOVE,{evt:evt});if(dd){dd._drag(evt);}},_setPointerPosition:function(evt){var contentPosition=this._getContentPosition(),offsetX=evt.offsetX,clientX=evt.clientX,x=null,y=null,touch;evt=evt?evt:window.event;if(evt.touches!==undefined){if(evt.touches.length>0){touch=evt.touches[0];x=touch.clientX-contentPosition.left;y=touch.clientY-contentPosition.top;}}
else{if(offsetX!==undefined){x=offsetX;y=evt.offsetY;}
else if(Kinetic.UA.browser==='mozilla'){x=evt.layerX;y=evt.layerY;}
else if(clientX!==undefined&&contentPosition){x=clientX-contentPosition.left;y=evt.clientY-contentPosition.top;}}
if(x!==null&&y!==null){this.pointerPos={x:x,y:y};}},_getContentPosition:function(){var rect=this.content.getBoundingClientRect?this.content.getBoundingClientRect():{top:0,left:0};return{top:rect.top,left:rect.left};},_buildDOM:function(){var container=this.getContainer();if(!container){if(Kinetic.Util.isBrowser()){throw'Stage has not container. But container is required';}else{container=Kinetic.document.createElement(DIV);}}
container.innerHTML=EMPTY_STRING;this.content=Kinetic.document.createElement(DIV);this.content.style.position=RELATIVE;this.content.style.display=INLINE_BLOCK;this.content.className=KINETICJS_CONTENT;this.content.setAttribute('role','presentation');container.appendChild(this.content);this.bufferCanvas=new Kinetic.SceneCanvas({pixelRatio:1});this.bufferHitCanvas=new Kinetic.HitCanvas();this._resizeDOM();},_onContent:function(typesStr,handler){var types=typesStr.split(SPACE),len=types.length,n,baseEvent;for(n=0;n<len;n++){baseEvent=types[n];this.content.addEventListener(baseEvent,handler,false);}},cache:function(){Kinetic.Util.warn('Cache function is not allowed for stage. You may use cache only for layers, groups and shapes.');return;},clearCache:function(){}});Kinetic.Util.extend(Kinetic.Stage,Kinetic.Container);Kinetic.Factory.addGetter(Kinetic.Stage,'container');Kinetic.Factory.addOverloadedGetterSetter(Kinetic.Stage,'container');})();;(function(){Kinetic.Util.addMethods(Kinetic.BaseLayer,{___init:function(config){this.nodeType='Layer';Kinetic.Container.call(this,config);},createPNGStream:function(){return this.canvas._canvas.createPNGStream();},getCanvas:function(){return this.canvas;},getHitCanvas:function(){return this.hitCanvas;},getContext:function(){return this.getCanvas().getContext();},clear:function(bounds){this.getContext().clear(bounds);this.getHitCanvas().getContext().clear(bounds);return this;},setZIndex:function(index){Kinetic.Node.prototype.setZIndex.call(this,index);var stage=this.getStage();if(stage){stage.content.removeChild(this.getCanvas()._canvas);if(index<stage.getChildren().length-1){stage.content.insertBefore(this.getCanvas()._canvas,stage.getChildren()[index+1].getCanvas()._canvas);}
else{stage.content.appendChild(this.getCanvas()._canvas);}}
return this;},moveToTop:function(){Kinetic.Node.prototype.moveToTop.call(this);var stage=this.getStage();if(stage){stage.content.removeChild(this.getCanvas()._canvas);stage.content.appendChild(this.getCanvas()._canvas);}},moveUp:function(){if(Kinetic.Node.prototype.moveUp.call(this)){var stage=this.getStage();if(stage){stage.content.removeChild(this.getCanvas()._canvas);if(this.index<stage.getChildren().length-1){stage.content.insertBefore(this.getCanvas()._canvas,stage.getChildren()[this.index+1].getCanvas()._canvas);}
else{stage.content.appendChild(this.getCanvas()._canvas);}}}},moveDown:function(){if(Kinetic.Node.prototype.moveDown.call(this)){var stage=this.getStage();if(stage){var children=stage.getChildren();stage.content.removeChild(this.getCanvas()._canvas);stage.content.insertBefore(this.getCanvas()._canvas,children[this.index+1].getCanvas()._canvas);}}},moveToBottom:function(){if(Kinetic.Node.prototype.moveToBottom.call(this)){var stage=this.getStage();if(stage){var children=stage.getChildren();stage.content.removeChild(this.getCanvas()._canvas);stage.content.insertBefore(this.getCanvas()._canvas,children[1].getCanvas()._canvas);}}},getLayer:function(){return this;},remove:function(){var _canvas=this.getCanvas()._canvas;Kinetic.Node.prototype.remove.call(this);if(_canvas&&_canvas.parentNode&&Kinetic.Util._isInDocument(_canvas)){_canvas.parentNode.removeChild(_canvas);}
return this;},getStage:function(){return this.parent;}});Kinetic.Util.extend(Kinetic.BaseLayer,Kinetic.Container);Kinetic.Factory.addGetterSetter(Kinetic.BaseLayer,'clearBeforeDraw',true);Kinetic.Collection.mapMethods(Kinetic.BaseLayer);})();;(function(){var HASH='#',BEFORE_DRAW='beforeDraw',DRAW='draw',INTERSECTION_OFFSETS=[{x:0,y:0},{x:-1,y:0},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:1,y:0},{x:1,y:1},{x:0,y:1},{x:-1,y:1}],INTERSECTION_OFFSETS_LEN=INTERSECTION_OFFSETS.length;Kinetic.Util.addMethods(Kinetic.Layer,{____init:function(config){this.nodeType='Layer';this.canvas=new Kinetic.SceneCanvas();this.hitCanvas=new Kinetic.HitCanvas();Kinetic.BaseLayer.call(this,config);},_setCanvasSize:function(width,height){this.canvas.setSize(width,height);this.hitCanvas.setSize(width,height);},_validateAdd:function(child){var type=child.getType();if(type!=='Group'&&type!=='Shape'){Kinetic.Util.error('You may only add groups and shapes to a layer.');}},getIntersection:function(pos){var obj,i,intersectionOffset,shape;if(this.hitGraphEnabled()&&this.isVisible()){for(i=0;i<INTERSECTION_OFFSETS_LEN;i++){intersectionOffset=INTERSECTION_OFFSETS[i];obj=this._getIntersection({x:pos.x+intersectionOffset.x,y:pos.y+intersectionOffset.y});shape=obj.shape;if(shape){return shape;}
else if(!obj.antialiased){return null;}}}
else{return null;}},_getIntersection:function(pos){var p=this.hitCanvas.context._context.getImageData(pos.x,pos.y,1,1).data,p3=p[3],colorKey,shape;if(p3===255){colorKey=Kinetic.Util._rgbToHex(p[0],p[1],p[2]);shape=Kinetic.shapes[HASH+colorKey];return{shape:shape};}
else if(p3>0){return{antialiased:true};}
else{return{};}},drawScene:function(can,top){var layer=this.getLayer(),canvas=can||(layer&&layer.getCanvas());this._fire(BEFORE_DRAW,{node:this});if(this.getClearBeforeDraw()){canvas.getContext().clear();}
Kinetic.Container.prototype.drawScene.call(this,canvas,top);this._fire(DRAW,{node:this});return this;},_applyTransform:function(shape,context,top){var m=shape.getAbsoluteTransform(top).getMatrix();context.transform(m[0],m[1],m[2],m[3],m[4],m[5]);},drawHit:function(can,top){var layer=this.getLayer(),canvas=can||(layer&&layer.hitCanvas);if(layer&&layer.getClearBeforeDraw()){layer.getHitCanvas().getContext().clear();}
Kinetic.Container.prototype.drawHit.call(this,canvas,top);return this;},clear:function(bounds){this.getContext().clear(bounds);this.getHitCanvas().getContext().clear(bounds);return this;},setVisible:function(visible){Kinetic.Node.prototype.setVisible.call(this,visible);if(visible){this.getCanvas()._canvas.style.display='block';this.hitCanvas._canvas.style.display='block';}
else{this.getCanvas()._canvas.style.display='none';this.hitCanvas._canvas.style.display='none';}
return this;},enableHitGraph:function(){this.setHitGraphEnabled(true);return this;},disableHitGraph:function(){this.setHitGraphEnabled(false);return this;}});Kinetic.Util.extend(Kinetic.Layer,Kinetic.BaseLayer);Kinetic.Factory.addGetterSetter(Kinetic.Layer,'hitGraphEnabled',true);Kinetic.Collection.mapMethods(Kinetic.Layer);})();;(function(){var HASH='#',BEFORE_DRAW='beforeDraw',DRAW='draw';Kinetic.Util.addMethods(Kinetic.FastLayer,{____init:function(config){this.nodeType='Layer';this.canvas=new Kinetic.SceneCanvas();Kinetic.BaseLayer.call(this,config);},_validateAdd:function(child){var type=child.getType();if(type!=='Shape'){Kinetic.Util.error('You may only add shapes to a fast layer.');}},_setCanvasSize:function(width,height){this.canvas.setSize(width,height);},hitGraphEnabled:function(){return false;},getIntersection:function(){return null;},drawScene:function(can){var layer=this.getLayer(),canvas=can||(layer&&layer.getCanvas());if(this.getClearBeforeDraw()){canvas.getContext().clear();}
Kinetic.Container.prototype.drawScene.call(this,canvas);return this;},_applyTransform:function(shape,context,top){if(!top||top._id!==this._id){var m=shape.getTransform().getMatrix();context.transform(m[0],m[1],m[2],m[3],m[4],m[5]);}},draw:function(){this.drawScene();return this;},clear:function(bounds){this.getContext().clear(bounds);return this;},setVisible:function(visible){Kinetic.Node.prototype.setVisible.call(this,visible);if(visible){this.getCanvas()._canvas.style.display='block';}
else{this.getCanvas()._canvas.style.display='none';}
return this;}});Kinetic.Util.extend(Kinetic.FastLayer,Kinetic.BaseLayer);Kinetic.Collection.mapMethods(Kinetic.FastLayer);})();;(function(){Kinetic.Util.addMethods(Kinetic.Group,{___init:function(config){this.nodeType='Group';Kinetic.Container.call(this,config);},_validateAdd:function(child){var type=child.getType();if(type!=='Group'&&type!=='Shape'){Kinetic.Util.error('You may only add groups and shapes to groups.');}}});Kinetic.Util.extend(Kinetic.Group,Kinetic.Container);Kinetic.Collection.mapMethods(Kinetic.Group);})();;(function(){Kinetic.Rect=function(config){this.___init(config);};Kinetic.Rect.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className='Rect';this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){var cornerRadius=this.getCornerRadius(),width=this.getWidth(),height=this.getHeight();context.beginPath();if(!cornerRadius){context.rect(0,0,width,height);}
else{context.moveTo(cornerRadius,0);context.lineTo(width-cornerRadius,0);context.arc(width-cornerRadius,cornerRadius,cornerRadius,Math.PI*3/2,0,false);context.lineTo(width,height-cornerRadius);context.arc(width-cornerRadius,height-cornerRadius,cornerRadius,0,Math.PI/2,false);context.lineTo(cornerRadius,height);context.arc(cornerRadius,height-cornerRadius,cornerRadius,Math.PI/2,Math.PI,false);context.lineTo(0,cornerRadius);context.arc(cornerRadius,cornerRadius,cornerRadius,Math.PI,Math.PI*3/2,false);}
context.closePath();context.fillStrokeShape(this);}};Kinetic.Util.extend(Kinetic.Rect,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Rect,'cornerRadius',0);Kinetic.Collection.mapMethods(Kinetic.Rect);})();;(function(){var PIx2=(Math.PI*2)-0.0001,CIRCLE='Circle';Kinetic.Circle=function(config){this.___init(config);};Kinetic.Circle.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className=CIRCLE;this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){context.beginPath();context.arc(0,0,this.getRadius(),0,PIx2,false);context.closePath();context.fillStrokeShape(this);},getWidth:function(){return this.getRadius()*2;},getHeight:function(){return this.getRadius()*2;},setWidth:function(width){Kinetic.Node.prototype.setWidth.call(this,width);this.setRadius(width/2);},setHeight:function(height){Kinetic.Node.prototype.setHeight.call(this,height);this.setRadius(height/2);}};Kinetic.Util.extend(Kinetic.Circle,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Circle,'radius',0);Kinetic.Collection.mapMethods(Kinetic.Circle);})();;(function(){var PIx2=(Math.PI*2)-0.0001,ELLIPSE='Ellipse';Kinetic.Ellipse=function(config){this.___init(config);};Kinetic.Ellipse.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className=ELLIPSE;this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){var r=this.getRadius(),rx=r.x,ry=r.y;context.beginPath();context.save();if(rx!==ry){context.scale(1,ry/rx);}
context.arc(0,0,rx,0,PIx2,false);context.restore();context.closePath();context.fillStrokeShape(this);},getWidth:function(){return this.getRadius().x*2;},getHeight:function(){return this.getRadius().y*2;},setWidth:function(width){Kinetic.Node.prototype.setWidth.call(this,width);this.setRadius({x:width/2});},setHeight:function(height){Kinetic.Node.prototype.setHeight.call(this,height);this.setRadius({y:height/2});}};Kinetic.Util.extend(Kinetic.Ellipse,Kinetic.Shape);Kinetic.Factory.addComponentsGetterSetter(Kinetic.Ellipse,'radius',['x','y']);Kinetic.Factory.addGetterSetter(Kinetic.Ellipse,'radiusX',0);Kinetic.Factory.addGetterSetter(Kinetic.Ellipse,'radiusY',0);Kinetic.Collection.mapMethods(Kinetic.Ellipse);})();;(function(){var PIx2=(Math.PI*2)-0.0001;Kinetic.Ring=function(config){this.___init(config);};Kinetic.Ring.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className='Ring';this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){context.beginPath();context.arc(0,0,this.getInnerRadius(),0,PIx2,false);context.moveTo(this.getOuterRadius(),0);context.arc(0,0,this.getOuterRadius(),PIx2,0,true);context.closePath();context.fillStrokeShape(this);},getWidth:function(){return this.getOuterRadius()*2;},getHeight:function(){return this.getOuterRadius()*2;},setWidth:function(width){Kinetic.Node.prototype.setWidth.call(this,width);this.setOuterRadius(width/2);},setHeight:function(height){Kinetic.Node.prototype.setHeight.call(this,height);this.setOuterRadius(height/2);}};Kinetic.Util.extend(Kinetic.Ring,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Ring,'innerRadius',0);Kinetic.Factory.addGetterSetter(Kinetic.Ring,'outerRadius',0);Kinetic.Collection.mapMethods(Kinetic.Ring);})();;(function(){Kinetic.Wedge=function(config){this.___init(config);};Kinetic.Wedge.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className='Wedge';this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){context.beginPath();context.arc(0,0,this.getRadius(),0,Kinetic.getAngle(this.getAngle()),this.getClockwise());context.lineTo(0,0);context.closePath();context.fillStrokeShape(this);}};Kinetic.Util.extend(Kinetic.Wedge,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Wedge,'radius',0);Kinetic.Factory.addGetterSetter(Kinetic.Wedge,'angle',0);Kinetic.Factory.addGetterSetter(Kinetic.Wedge,'clockwise',false);Kinetic.Factory.backCompat(Kinetic.Wedge,{angleDeg:'angle',getAngleDeg:'getAngle',setAngleDeg:'setAngle'});Kinetic.Collection.mapMethods(Kinetic.Wedge);})();;(function(){var PI_OVER_180=Math.PI/180;Kinetic.Arc=function(config){this.___init(config);};Kinetic.Arc.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className='Arc';this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){var angle=Kinetic.getAngle(this.angle()),clockwise=this.clockwise();context.beginPath();context.arc(0,0,this.getOuterRadius(),0,angle,clockwise);context.arc(0,0,this.getInnerRadius(),angle,0,!clockwise);context.closePath();context.fillStrokeShape(this);}};Kinetic.Util.extend(Kinetic.Arc,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Arc,'innerRadius',0);Kinetic.Factory.addGetterSetter(Kinetic.Arc,'outerRadius',0);Kinetic.Factory.addGetterSetter(Kinetic.Arc,'angle',0);Kinetic.Factory.addGetterSetter(Kinetic.Arc,'clockwise',false);Kinetic.Collection.mapMethods(Kinetic.Arc);})();;(function(){var IMAGE='Image';Kinetic.Image=function(config){this.___init(config);};Kinetic.Image.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className=IMAGE;this.sceneFunc(this._sceneFunc);this.hitFunc(this._hitFunc);},_useBufferCanvas:function(){return(this.hasShadow()||this.getAbsoluteOpacity()!==1)&&this.hasStroke();},_sceneFunc:function(context){var width=this.getWidth(),height=this.getHeight(),image=this.getImage(),crop,cropWidth,cropHeight,params;if(image){crop=this.getCrop();cropWidth=crop.width;cropHeight=crop.height;if(cropWidth&&cropHeight){params=[image,crop.x,crop.y,cropWidth,cropHeight,0,0,width,height];}else{params=[image,0,0,width,height];}}
context.beginPath();context.rect(0,0,width,height);context.closePath();context.fillStrokeShape(this);if(image){context.drawImage.apply(context,params);}},_hitFunc:function(context){var width=this.getWidth(),height=this.getHeight();context.beginPath();context.rect(0,0,width,height);context.closePath();context.fillStrokeShape(this);},getWidth:function(){var image=this.getImage();return this.attrs.width||(image?image.width:0);},getHeight:function(){var image=this.getImage();return this.attrs.height||(image?image.height:0);}};Kinetic.Util.extend(Kinetic.Image,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Image,'image');Kinetic.Factory.addComponentsGetterSetter(Kinetic.Image,'crop',['x','y','width','height']);Kinetic.Factory.addGetterSetter(Kinetic.Image,'cropX',0);Kinetic.Factory.addGetterSetter(Kinetic.Image,'cropY',0);Kinetic.Factory.addGetterSetter(Kinetic.Image,'cropWidth',0);Kinetic.Factory.addGetterSetter(Kinetic.Image,'cropHeight',0);Kinetic.Collection.mapMethods(Kinetic.Image);})();;(function(){var AUTO='auto',CENTER='center',CHANGE_KINETIC='Change.kinetic',CONTEXT_2D='2d',DASH='-',EMPTY_STRING='',LEFT='left',TEXT='text',TEXT_UPPER='Text',MIDDLE='middle',NORMAL='normal',PX_SPACE='px ',SPACE=' ',RIGHT='right',WORD='word',CHAR='char',NONE='none',ATTR_CHANGE_LIST=['fontFamily','fontSize','fontStyle','fontVariant','padding','align','lineHeight','text','width','height','wrap'],attrChangeListLen=ATTR_CHANGE_LIST.length,dummyContext=Kinetic.Util.createCanvasElement().getContext(CONTEXT_2D);Kinetic.Text=function(config){this.___init(config);};function _fillFunc(context){context.fillText(this.partialText,0,0);}
function _strokeFunc(context){context.strokeText(this.partialText,0,0);}
Kinetic.Text.prototype={___init:function(config){var that=this;if(config.width===undefined){config.width=AUTO;}
if(config.height===undefined){config.height=AUTO;}
Kinetic.Shape.call(this,config);this._fillFunc=_fillFunc;this._strokeFunc=_strokeFunc;this.className=TEXT_UPPER;for(var n=0;n<attrChangeListLen;n++){this.on(ATTR_CHANGE_LIST[n]+CHANGE_KINETIC,that._setTextData);}
this._setTextData();this.sceneFunc(this._sceneFunc);this.hitFunc(this._hitFunc);},_sceneFunc:function(context){var p=this.getPadding(),textHeight=this.getTextHeight(),lineHeightPx=this.getLineHeight()*textHeight,textArr=this.textArr,textArrLen=textArr.length,totalWidth=this.getWidth(),n;context.setAttr('font',this._getContextFont());context.setAttr('textBaseline',MIDDLE);context.setAttr('textAlign',LEFT);context.save();context.translate(p,0);context.translate(0,p+textHeight/2);for(n=0;n<textArrLen;n++){var obj=textArr[n],text=obj.text,width=obj.width;context.save();if(this.getAlign()===RIGHT){context.translate(totalWidth-width-p*2,0);}
else if(this.getAlign()===CENTER){context.translate((totalWidth-width-p*2)/2,0);}
this.partialText=text;context.fillStrokeShape(this);context.restore();context.translate(0,lineHeightPx);}
context.restore();},_hitFunc:function(context){var width=this.getWidth(),height=this.getHeight();context.beginPath();context.rect(0,0,width,height);context.closePath();context.fillStrokeShape(this);},setText:function(text){var str=Kinetic.Util._isString(text)?text:text.toString();this._setAttr(TEXT,str);return this;},getWidth:function(){return this.attrs.width===AUTO?this.getTextWidth()+this.getPadding()*2:this.attrs.width;},getHeight:function(){return this.attrs.height===AUTO?(this.getTextHeight()*this.textArr.length*this.getLineHeight())+this.getPadding()*2:this.attrs.height;},getTextWidth:function(){return this.textWidth;},getTextHeight:function(){return this.textHeight;},_getTextSize:function(text){var _context=dummyContext,fontSize=this.getFontSize(),metrics;_context.save();_context.font=this._getContextFont();metrics=_context.measureText(text);_context.restore();return{width:metrics.width,height:parseInt(fontSize,10)};},_getContextFont:function(){return this.getFontStyle()+SPACE+this.getFontVariant()+SPACE+this.getFontSize()+PX_SPACE+this.getFontFamily();},_addTextLine:function(line,width){return this.textArr.push({text:line,width:width});},_getTextWidth:function(text){return dummyContext.measureText(text).width;},_setTextData:function(){var lines=this.getText().split('\n'),fontSize=+this.getFontSize(),textWidth=0,lineHeightPx=this.getLineHeight()*fontSize,width=this.attrs.width,height=this.attrs.height,fixedWidth=width!==AUTO,fixedHeight=height!==AUTO,padding=this.getPadding(),maxWidth=width-padding*2,maxHeightPx=height-padding*2,currentHeightPx=0,wrap=this.getWrap(),shouldWrap=wrap!==NONE,wrapAtWord=wrap!==CHAR&&shouldWrap;this.textArr=[];dummyContext.save();dummyContext.font=this._getContextFont();for(var i=0,max=lines.length;i<max;++i){var line=lines[i],lineWidth=this._getTextWidth(line);if(fixedWidth&&lineWidth>maxWidth){while(line.length>0){var low=0,high=line.length,match='',matchWidth=0;while(low<high){var mid=(low+high)>>>1,substr=line.slice(0,mid+1),substrWidth=this._getTextWidth(substr);if(substrWidth<=maxWidth){low=mid+1;match=substr;matchWidth=substrWidth;}else{high=mid;}}
if(match){if(wrapAtWord){var wrapIndex=Math.max(match.lastIndexOf(SPACE),match.lastIndexOf(DASH))+1;if(wrapIndex>0){low=wrapIndex;match=match.slice(0,low);matchWidth=this._getTextWidth(match);}}
this._addTextLine(match,matchWidth);textWidth=Math.max(textWidth,matchWidth);currentHeightPx+=lineHeightPx;if(!shouldWrap||(fixedHeight&&currentHeightPx+lineHeightPx>maxHeightPx)){break;}
line=line.slice(low);if(line.length>0){lineWidth=this._getTextWidth(line);if(lineWidth<=maxWidth){this._addTextLine(line,lineWidth);currentHeightPx+=lineHeightPx;textWidth=Math.max(textWidth,lineWidth);break;}}}else{break;}}}else{this._addTextLine(line,lineWidth);currentHeightPx+=lineHeightPx;textWidth=Math.max(textWidth,lineWidth);}
if(fixedHeight&&currentHeightPx+lineHeightPx>maxHeightPx){break;}}
dummyContext.restore();this.textHeight=fontSize;this.textWidth=textWidth;}};Kinetic.Util.extend(Kinetic.Text,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Text,'fontFamily','Arial');Kinetic.Factory.addGetterSetter(Kinetic.Text,'fontSize',12);Kinetic.Factory.addGetterSetter(Kinetic.Text,'fontStyle',NORMAL);Kinetic.Factory.addGetterSetter(Kinetic.Text,'fontVariant',NORMAL);Kinetic.Factory.addGetterSetter(Kinetic.Text,'padding',0);Kinetic.Factory.addGetterSetter(Kinetic.Text,'align',LEFT);Kinetic.Factory.addGetterSetter(Kinetic.Text,'lineHeight',1);Kinetic.Factory.addGetterSetter(Kinetic.Text,'wrap',WORD);Kinetic.Factory.addGetter(Kinetic.Text,'text',EMPTY_STRING);Kinetic.Factory.addOverloadedGetterSetter(Kinetic.Text,'text');Kinetic.Collection.mapMethods(Kinetic.Text);})();;(function(){Kinetic.Line=function(config){this.___init(config);};Kinetic.Line.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className='Line';this.on('pointsChange.kinetic tensionChange.kinetic closedChange.kinetic',function(){this._clearCache('tensionPoints');});this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){var points=this.getPoints(),length=points.length,tension=this.getTension(),closed=this.getClosed(),tp,len,n;context.beginPath();context.moveTo(points[0],points[1]);if(tension!==0&&length>4){tp=this.getTensionPoints();len=tp.length;n=closed?0:4;if(!closed){context.quadraticCurveTo(tp[0],tp[1],tp[2],tp[3]);}
while(n<len-2){context.bezierCurveTo(tp[n++],tp[n++],tp[n++],tp[n++],tp[n++],tp[n++]);}
if(!closed){context.quadraticCurveTo(tp[len-2],tp[len-1],points[length-2],points[length-1]);}}
else{for(n=2;n<length;n+=2){context.lineTo(points[n],points[n+1]);}}
if(closed){context.closePath();context.fillStrokeShape(this);}
else{context.strokeShape(this);}},getTensionPoints:function(){return this._getCache('tensionPoints',this._getTensionPoints);},_getTensionPoints:function(){if(this.getClosed()){return this._getTensionPointsClosed();}
else{return Kinetic.Util._expandPoints(this.getPoints(),this.getTension());}},_getTensionPointsClosed:function(){var p=this.getPoints(),len=p.length,tension=this.getTension(),util=Kinetic.Util,firstControlPoints=util._getControlPoints(p[len-2],p[len-1],p[0],p[1],p[2],p[3],tension),lastControlPoints=util._getControlPoints(p[len-4],p[len-3],p[len-2],p[len-1],p[0],p[1],tension),middle=Kinetic.Util._expandPoints(p,tension),tp=[firstControlPoints[2],firstControlPoints[3]]
.concat(middle)
.concat([lastControlPoints[0],lastControlPoints[1],p[len-2],p[len-1],lastControlPoints[2],lastControlPoints[3],firstControlPoints[0],firstControlPoints[1],p[0],p[1]]);return tp;}};Kinetic.Util.extend(Kinetic.Line,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Line,'closed',false);Kinetic.Factory.addGetterSetter(Kinetic.Line,'tension',0);Kinetic.Factory.addGetterSetter(Kinetic.Line,'points');Kinetic.Collection.mapMethods(Kinetic.Line);})();;(function(){Kinetic.Sprite=function(config){this.___init(config);};Kinetic.Sprite.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className='Sprite';this.anim=new Kinetic.Animation();this.on('animationChange.kinetic',function(){this.frameIndex(0);});this.on('frameRateChange.kinetic',function(){if(!this.anim.isRunning()){return;}
clearInterval(this.interval);this._setInterval();});this.sceneFunc(this._sceneFunc);this.hitFunc(this._hitFunc);},_sceneFunc:function(context){var anim=this.getAnimation(),index=this.frameIndex(),ix4=index*4,set=this.getAnimations()[anim],x=set[ix4+0],y=set[ix4+1],width=set[ix4+2],height=set[ix4+3],image=this.getImage();if(image){context.drawImage(image,x,y,width,height,0,0,width,height);}},_hitFunc:function(context){var anim=this.getAnimation(),index=this.frameIndex(),ix4=index*4,set=this.getAnimations()[anim],width=set[ix4+2],height=set[ix4+3];context.beginPath();context.rect(0,0,width,height);context.closePath();context.fillShape(this);},_useBufferCanvas:function(){return(this.hasShadow()||this.getAbsoluteOpacity()!==1)&&this.hasStroke();},_setInterval:function(){var that=this;this.interval=setInterval(function(){that._updateIndex();},1000/this.getFrameRate());},start:function(){var layer=this.getLayer();this.anim.setLayers(layer);this._setInterval();this.anim.start();},stop:function(){this.anim.stop();clearInterval(this.interval);},isRunning:function(){return this.anim.isRunning();},_updateIndex:function(){var index=this.frameIndex(),animation=this.getAnimation(),animations=this.getAnimations(),anim=animations[animation],len=anim.length/4;if(index<len-1){this.frameIndex(index+1);}
else{this.frameIndex(0);}}};Kinetic.Util.extend(Kinetic.Sprite,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Sprite,'animation');Kinetic.Factory.addGetterSetter(Kinetic.Sprite,'animations');Kinetic.Factory.addGetterSetter(Kinetic.Sprite,'image');Kinetic.Factory.addGetterSetter(Kinetic.Sprite,'frameIndex',0);Kinetic.Factory.addGetterSetter(Kinetic.Sprite,'frameRate',17);Kinetic.Factory.backCompat(Kinetic.Sprite,{index:'frameIndex',getIndex:'getFrameIndex',setIndex:'setFrameIndex'});Kinetic.Collection.mapMethods(Kinetic.Sprite);})();;(function(){Kinetic.Path=function(config){this.___init(config);};Kinetic.Path.prototype={___init:function(config){this.dataArray=[];var that=this;Kinetic.Shape.call(this,config);this.className='Path';this.dataArray=Kinetic.Path.parsePathData(this.getData());this.on('dataChange.kinetic',function(){that.dataArray=Kinetic.Path.parsePathData(this.getData());});this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){var ca=this.dataArray,closedPath=false;context.beginPath();for(var n=0;n<ca.length;n++){var c=ca[n].command;var p=ca[n].points;switch(c){case'L':context.lineTo(p[0],p[1]);break;case'M':context.moveTo(p[0],p[1]);break;case'C':context.bezierCurveTo(p[0],p[1],p[2],p[3],p[4],p[5]);break;case'Q':context.quadraticCurveTo(p[0],p[1],p[2],p[3]);break;case'A':var cx=p[0],cy=p[1],rx=p[2],ry=p[3],theta=p[4],dTheta=p[5],psi=p[6],fs=p[7];var r=(rx>ry)?rx:ry;var scaleX=(rx>ry)?1:rx/ry;var scaleY=(rx>ry)?ry/rx:1;context.translate(cx,cy);context.rotate(psi);context.scale(scaleX,scaleY);context.arc(0,0,r,theta,theta+dTheta,1-fs);context.scale(1/scaleX,1/scaleY);context.rotate(-psi);context.translate(-cx,-cy);break;case'z':context.closePath();closedPath=true;break;}}
if(closedPath){context.fillStrokeShape(this);}
else{context.strokeShape(this);}}};Kinetic.Util.extend(Kinetic.Path,Kinetic.Shape);Kinetic.Path.getLineLength=function(x1,y1,x2,y2){return Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));};Kinetic.Path.getPointOnLine=function(dist,P1x,P1y,P2x,P2y,fromX,fromY){if(fromX===undefined){fromX=P1x;}
if(fromY===undefined){fromY=P1y;}
var m=(P2y-P1y)/((P2x-P1x)+0.00000001);var run=Math.sqrt(dist*dist/(1+m*m));if(P2x<P1x){run*=-1;}
var rise=m*run;var pt;if(P2x===P1x){pt={x:fromX,y:fromY+rise};}else if((fromY-P1y)/((fromX-P1x)+0.00000001)===m){pt={x:fromX+run,y:fromY+rise};}
else{var ix,iy;var len=this.getLineLength(P1x,P1y,P2x,P2y);if(len<0.00000001){return undefined;}
var u=(((fromX-P1x)*(P2x-P1x))+((fromY-P1y)*(P2y-P1y)));u=u/(len*len);ix=P1x+u*(P2x-P1x);iy=P1y+u*(P2y-P1y);var pRise=this.getLineLength(fromX,fromY,ix,iy);var pRun=Math.sqrt(dist*dist-pRise*pRise);run=Math.sqrt(pRun*pRun/(1+m*m));if(P2x<P1x){run*=-1;}
rise=m*run;pt={x:ix+run,y:iy+rise};}
return pt;};Kinetic.Path.getPointOnCubicBezier=function(pct,P1x,P1y,P2x,P2y,P3x,P3y,P4x,P4y){function CB1(t){return t*t*t;}
function CB2(t){return 3*t*t*(1-t);}
function CB3(t){return 3*t*(1-t)*(1-t);}
function CB4(t){return(1-t)*(1-t)*(1-t);}
var x=P4x*CB1(pct)+P3x*CB2(pct)+P2x*CB3(pct)+P1x*CB4(pct);var y=P4y*CB1(pct)+P3y*CB2(pct)+P2y*CB3(pct)+P1y*CB4(pct);return{x:x,y:y};};Kinetic.Path.getPointOnQuadraticBezier=function(pct,P1x,P1y,P2x,P2y,P3x,P3y){function QB1(t){return t*t;}
function QB2(t){return 2*t*(1-t);}
function QB3(t){return(1-t)*(1-t);}
var x=P3x*QB1(pct)+P2x*QB2(pct)+P1x*QB3(pct);var y=P3y*QB1(pct)+P2y*QB2(pct)+P1y*QB3(pct);return{x:x,y:y};};Kinetic.Path.getPointOnEllipticalArc=function(cx,cy,rx,ry,theta,psi){var cosPsi=Math.cos(psi),sinPsi=Math.sin(psi);var pt={x:rx*Math.cos(theta),y:ry*Math.sin(theta)};return{x:cx+(pt.x*cosPsi-pt.y*sinPsi),y:cy+(pt.x*sinPsi+pt.y*cosPsi)};};Kinetic.Path.parsePathData=function(data){if(!data){return[];}
var cs=data;var cc=['m','M','l','L','v','V','h','H','z','Z','c','C','q','Q','t','T','s','S','a','A'];cs=cs.replace(new RegExp(' ','g'),',');for(var n=0;n<cc.length;n++){cs=cs.replace(new RegExp(cc[n],'g'),'|'+cc[n]);}
var arr=cs.split('|');var ca=[];var cpx=0;var cpy=0;for(n=1;n<arr.length;n++){var str=arr[n];var c=str.charAt(0);str=str.slice(1);str=str.replace(new RegExp(',-','g'),'-');str=str.replace(new RegExp('-','g'),',-');str=str.replace(new RegExp('e,-','g'),'e-');var p=str.split(',');if(p.length>0&&p[0]===''){p.shift();}
for(var i=0;i<p.length;i++){p[i]=parseFloat(p[i]);}
while(p.length>0){if(isNaN(p[0])){break;}
var cmd=null;var points=[];var startX=cpx,startY=cpy;var prevCmd,ctlPtx,ctlPty;var rx,ry,psi,fa,fs,x1,y1;switch(c){case'l':cpx+=p.shift();cpy+=p.shift();cmd='L';points.push(cpx,cpy);break;case'L':cpx=p.shift();cpy=p.shift();points.push(cpx,cpy);break;case'm':var dx=p.shift();var dy=p.shift();cpx+=dx;cpy+=dy;cmd='M';if(ca.length>2&&ca[ca.length-1].command==='z'){for(var idx=ca.length-2;idx>=0;idx--){if(ca[idx].command==='M'){cpx=ca[idx].points[0]+dx;cpy=ca[idx].points[1]+dy;break;}}}
points.push(cpx,cpy);c='l';break;case'M':cpx=p.shift();cpy=p.shift();cmd='M';points.push(cpx,cpy);c='L';break;case'h':cpx+=p.shift();cmd='L';points.push(cpx,cpy);break;case'H':cpx=p.shift();cmd='L';points.push(cpx,cpy);break;case'v':cpy+=p.shift();cmd='L';points.push(cpx,cpy);break;case'V':cpy=p.shift();cmd='L';points.push(cpx,cpy);break;case'C':points.push(p.shift(),p.shift(),p.shift(),p.shift());cpx=p.shift();cpy=p.shift();points.push(cpx,cpy);break;case'c':points.push(cpx+p.shift(),cpy+p.shift(),cpx+p.shift(),cpy+p.shift());cpx+=p.shift();cpy+=p.shift();cmd='C';points.push(cpx,cpy);break;case'S':ctlPtx=cpx;ctlPty=cpy;prevCmd=ca[ca.length-1];if(prevCmd.command==='C'){ctlPtx=cpx+(cpx-prevCmd.points[2]);ctlPty=cpy+(cpy-prevCmd.points[3]);}
points.push(ctlPtx,ctlPty,p.shift(),p.shift());cpx=p.shift();cpy=p.shift();cmd='C';points.push(cpx,cpy);break;case's':ctlPtx=cpx;ctlPty=cpy;prevCmd=ca[ca.length-1];if(prevCmd.command==='C'){ctlPtx=cpx+(cpx-prevCmd.points[2]);ctlPty=cpy+(cpy-prevCmd.points[3]);}
points.push(ctlPtx,ctlPty,cpx+p.shift(),cpy+p.shift());cpx+=p.shift();cpy+=p.shift();cmd='C';points.push(cpx,cpy);break;case'Q':points.push(p.shift(),p.shift());cpx=p.shift();cpy=p.shift();points.push(cpx,cpy);break;case'q':points.push(cpx+p.shift(),cpy+p.shift());cpx+=p.shift();cpy+=p.shift();cmd='Q';points.push(cpx,cpy);break;case'T':ctlPtx=cpx;ctlPty=cpy;prevCmd=ca[ca.length-1];if(prevCmd.command==='Q'){ctlPtx=cpx+(cpx-prevCmd.points[0]);ctlPty=cpy+(cpy-prevCmd.points[1]);}
cpx=p.shift();cpy=p.shift();cmd='Q';points.push(ctlPtx,ctlPty,cpx,cpy);break;case't':ctlPtx=cpx;ctlPty=cpy;prevCmd=ca[ca.length-1];if(prevCmd.command==='Q'){ctlPtx=cpx+(cpx-prevCmd.points[0]);ctlPty=cpy+(cpy-prevCmd.points[1]);}
cpx+=p.shift();cpy+=p.shift();cmd='Q';points.push(ctlPtx,ctlPty,cpx,cpy);break;case'A':rx=p.shift();ry=p.shift();psi=p.shift();fa=p.shift();fs=p.shift();x1=cpx;y1=cpy;cpx=p.shift();cpy=p.shift();cmd='A';points=this.convertEndpointToCenterParameterization(x1,y1,cpx,cpy,fa,fs,rx,ry,psi);break;case'a':rx=p.shift();ry=p.shift();psi=p.shift();fa=p.shift();fs=p.shift();x1=cpx;y1=cpy;cpx+=p.shift();cpy+=p.shift();cmd='A';points=this.convertEndpointToCenterParameterization(x1,y1,cpx,cpy,fa,fs,rx,ry,psi);break;}
ca.push({command:cmd||c,points:points,start:{x:startX,y:startY},pathLength:this.calcLength(startX,startY,cmd||c,points)});}
if(c==='z'||c==='Z'){ca.push({command:'z',points:[],start:undefined,pathLength:0});}}
return ca;};Kinetic.Path.calcLength=function(x,y,cmd,points){var len,p1,p2,t;var path=Kinetic.Path;switch(cmd){case'L':return path.getLineLength(x,y,points[0],points[1]);case'C':len=0.0;p1=path.getPointOnCubicBezier(0,x,y,points[0],points[1],points[2],points[3],points[4],points[5]);for(t=0.01;t<=1;t+=0.01){p2=path.getPointOnCubicBezier(t,x,y,points[0],points[1],points[2],points[3],points[4],points[5]);len+=path.getLineLength(p1.x,p1.y,p2.x,p2.y);p1=p2;}
return len;case'Q':len=0.0;p1=path.getPointOnQuadraticBezier(0,x,y,points[0],points[1],points[2],points[3]);for(t=0.01;t<=1;t+=0.01){p2=path.getPointOnQuadraticBezier(t,x,y,points[0],points[1],points[2],points[3]);len+=path.getLineLength(p1.x,p1.y,p2.x,p2.y);p1=p2;}
return len;case'A':len=0.0;var start=points[4];var dTheta=points[5];var end=points[4]+dTheta;var inc=Math.PI/180.0;if(Math.abs(start-end)<inc){inc=Math.abs(start-end);}
p1=path.getPointOnEllipticalArc(points[0],points[1],points[2],points[3],start,0);if(dTheta<0){for(t=start-inc;t>end;t-=inc){p2=path.getPointOnEllipticalArc(points[0],points[1],points[2],points[3],t,0);len+=path.getLineLength(p1.x,p1.y,p2.x,p2.y);p1=p2;}}
else{for(t=start+inc;t<end;t+=inc){p2=path.getPointOnEllipticalArc(points[0],points[1],points[2],points[3],t,0);len+=path.getLineLength(p1.x,p1.y,p2.x,p2.y);p1=p2;}}
p2=path.getPointOnEllipticalArc(points[0],points[1],points[2],points[3],end,0);len+=path.getLineLength(p1.x,p1.y,p2.x,p2.y);return len;}
return 0;};Kinetic.Path.convertEndpointToCenterParameterization=function(x1,y1,x2,y2,fa,fs,rx,ry,psiDeg){var psi=psiDeg*(Math.PI/180.0);var xp=Math.cos(psi)*(x1-x2)/2.0+Math.sin(psi)*(y1-y2)/2.0;var yp=-1*Math.sin(psi)*(x1-x2)/2.0+Math.cos(psi)*(y1-y2)/2.0;var lambda=(xp*xp)/(rx*rx)+(yp*yp)/(ry*ry);if(lambda>1){rx*=Math.sqrt(lambda);ry*=Math.sqrt(lambda);}
var f=Math.sqrt((((rx*rx)*(ry*ry))-((rx*rx)*(yp*yp))-((ry*ry)*(xp*xp)))/((rx*rx)*(yp*yp)+(ry*ry)*(xp*xp)));if(fa===fs){f*=-1;}
if(isNaN(f)){f=0;}
var cxp=f*rx*yp/ry;var cyp=f*-ry*xp/rx;var cx=(x1+x2)/2.0+Math.cos(psi)*cxp-Math.sin(psi)*cyp;var cy=(y1+y2)/2.0+Math.sin(psi)*cxp+Math.cos(psi)*cyp;var vMag=function(v){return Math.sqrt(v[0]*v[0]+v[1]*v[1]);};var vRatio=function(u,v){return(u[0]*v[0]+u[1]*v[1])/(vMag(u)*vMag(v));};var vAngle=function(u,v){return(u[0]*v[1]<u[1]*v[0]?-1:1)*Math.acos(vRatio(u,v));};var theta=vAngle([1,0],[(xp-cxp)/rx,(yp-cyp)/ry]);var u=[(xp-cxp)/rx,(yp-cyp)/ry];var v=[(-1*xp-cxp)/rx,(-1*yp-cyp)/ry];var dTheta=vAngle(u,v);if(vRatio(u,v)<=-1){dTheta=Math.PI;}
if(vRatio(u,v)>=1){dTheta=0;}
if(fs===0&&dTheta>0){dTheta=dTheta-2*Math.PI;}
if(fs===1&&dTheta<0){dTheta=dTheta+2*Math.PI;}
return[cx,cy,rx,ry,theta,dTheta,psi,fs];};Kinetic.Factory.addGetterSetter(Kinetic.Path,'data');Kinetic.Collection.mapMethods(Kinetic.Path);})();;(function(){var EMPTY_STRING='',NORMAL='normal';Kinetic.TextPath=function(config){this.___init(config);};function _fillFunc(context){context.fillText(this.partialText,0,0);}
function _strokeFunc(context){context.strokeText(this.partialText,0,0);}
Kinetic.TextPath.prototype={___init:function(config){var that=this;this.dummyCanvas=Kinetic.Util.createCanvasElement();this.dataArray=[];Kinetic.Shape.call(this,config);this._fillFunc=_fillFunc;this._strokeFunc=_strokeFunc;this._fillFuncHit=_fillFunc;this._strokeFuncHit=_strokeFunc;this.className='TextPath';this.dataArray=Kinetic.Path.parsePathData(this.attrs.data);this.on('dataChange.kinetic',function(){that.dataArray=Kinetic.Path.parsePathData(this.attrs.data);});this.on('textChange.kinetic textStroke.kinetic textStrokeWidth.kinetic',that._setTextData);that._setTextData();this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){context.setAttr('font',this._getContextFont());context.setAttr('textBaseline','middle');context.setAttr('textAlign','left');context.save();var glyphInfo=this.glyphInfo;for(var i=0;i<glyphInfo.length;i++){context.save();var p0=glyphInfo[i].p0;context.translate(p0.x,p0.y);context.rotate(glyphInfo[i].rotation);this.partialText=glyphInfo[i].text;context.fillStrokeShape(this);context.restore();}
context.restore();},getTextWidth:function(){return this.textWidth;},getTextHeight:function(){return this.textHeight;},setText:function(text){Kinetic.Text.prototype.setText.call(this,text);},_getTextSize:function(text){var dummyCanvas=this.dummyCanvas;var _context=dummyCanvas.getContext('2d');_context.save();_context.font=this._getContextFont();var metrics=_context.measureText(text);_context.restore();return{width:metrics.width,height:parseInt(this.attrs.fontSize,10)};},_setTextData:function(){var that=this;var size=this._getTextSize(this.attrs.text);this.textWidth=size.width;this.textHeight=size.height;this.glyphInfo=[];var charArr=this.attrs.text.split('');var p0,p1,pathCmd;var pIndex=-1;var currentT=0;var getNextPathSegment=function(){currentT=0;var pathData=that.dataArray;for(var i=pIndex+1;i<pathData.length;i++){if(pathData[i].pathLength>0){pIndex=i;return pathData[i];}
else if(pathData[i].command=='M'){p0={x:pathData[i].points[0],y:pathData[i].points[1]};}}
return{};};var findSegmentToFitCharacter=function(c){var glyphWidth=that._getTextSize(c).width;var currLen=0;var attempts=0;p1=undefined;while(Math.abs(glyphWidth-currLen)/glyphWidth>0.01&&attempts<25){attempts++;var cumulativePathLength=currLen;while(pathCmd===undefined){pathCmd=getNextPathSegment();if(pathCmd&&cumulativePathLength+pathCmd.pathLength<glyphWidth){cumulativePathLength+=pathCmd.pathLength;pathCmd=undefined;}}
if(pathCmd==={}||p0===undefined){return undefined;}
var needNewSegment=false;switch(pathCmd.command){case'L':if(Kinetic.Path.getLineLength(p0.x,p0.y,pathCmd.points[0],pathCmd.points[1])>glyphWidth){p1=Kinetic.Path.getPointOnLine(glyphWidth,p0.x,p0.y,pathCmd.points[0],pathCmd.points[1],p0.x,p0.y);}
else{pathCmd=undefined;}
break;case'A':var start=pathCmd.points[4];var dTheta=pathCmd.points[5];var end=pathCmd.points[4]+dTheta;if(currentT===0){currentT=start+0.00000001;}
else if(glyphWidth>currLen){currentT+=(Math.PI/180.0)*dTheta/Math.abs(dTheta);}
else{currentT-=Math.PI/360.0*dTheta/Math.abs(dTheta);}
if(dTheta<0&&currentT<end||dTheta>=0&&currentT>end){currentT=end;needNewSegment=true;}
p1=Kinetic.Path.getPointOnEllipticalArc(pathCmd.points[0],pathCmd.points[1],pathCmd.points[2],pathCmd.points[3],currentT,pathCmd.points[6]);break;case'C':if(currentT===0){if(glyphWidth>pathCmd.pathLength){currentT=0.00000001;}
else{currentT=glyphWidth/pathCmd.pathLength;}}
else if(glyphWidth>currLen){currentT+=(glyphWidth-currLen)/pathCmd.pathLength;}
else{currentT-=(currLen-glyphWidth)/pathCmd.pathLength;}
if(currentT>1.0){currentT=1.0;needNewSegment=true;}
p1=Kinetic.Path.getPointOnCubicBezier(currentT,pathCmd.start.x,pathCmd.start.y,pathCmd.points[0],pathCmd.points[1],pathCmd.points[2],pathCmd.points[3],pathCmd.points[4],pathCmd.points[5]);break;case'Q':if(currentT===0){currentT=glyphWidth/pathCmd.pathLength;}
else if(glyphWidth>currLen){currentT+=(glyphWidth-currLen)/pathCmd.pathLength;}
else{currentT-=(currLen-glyphWidth)/pathCmd.pathLength;}
if(currentT>1.0){currentT=1.0;needNewSegment=true;}
p1=Kinetic.Path.getPointOnQuadraticBezier(currentT,pathCmd.start.x,pathCmd.start.y,pathCmd.points[0],pathCmd.points[1],pathCmd.points[2],pathCmd.points[3]);break;}
if(p1!==undefined){currLen=Kinetic.Path.getLineLength(p0.x,p0.y,p1.x,p1.y);}
if(needNewSegment){needNewSegment=false;pathCmd=undefined;}}};for(var i=0;i<charArr.length;i++){findSegmentToFitCharacter(charArr[i]);if(p0===undefined||p1===undefined){break;}
var width=Kinetic.Path.getLineLength(p0.x,p0.y,p1.x,p1.y);var kern=0;var midpoint=Kinetic.Path.getPointOnLine(kern+width/2.0,p0.x,p0.y,p1.x,p1.y);var rotation=Math.atan2((p1.y-p0.y),(p1.x-p0.x));this.glyphInfo.push({transposeX:midpoint.x,transposeY:midpoint.y,text:charArr[i],rotation:rotation,p0:p0,p1:p1});p0=p1;}}};Kinetic.TextPath.prototype._getContextFont=Kinetic.Text.prototype._getContextFont;Kinetic.Util.extend(Kinetic.TextPath,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.TextPath,'fontFamily','Arial');Kinetic.Factory.addGetterSetter(Kinetic.TextPath,'fontSize',12);Kinetic.Factory.addGetterSetter(Kinetic.TextPath,'fontStyle',NORMAL);Kinetic.Factory.addGetterSetter(Kinetic.TextPath,'fontVariant',NORMAL);Kinetic.Factory.addGetter(Kinetic.TextPath,'text',EMPTY_STRING);Kinetic.Collection.mapMethods(Kinetic.TextPath);})();;(function(){Kinetic.RegularPolygon=function(config){this.___init(config);};Kinetic.RegularPolygon.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className='RegularPolygon';this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){var sides=this.attrs.sides,radius=this.attrs.radius,n,x,y;context.beginPath();context.moveTo(0,0-radius);for(n=1;n<sides;n++){x=radius*Math.sin(n*2*Math.PI/sides);y=-1*radius*Math.cos(n*2*Math.PI/sides);context.lineTo(x,y);}
context.closePath();context.fillStrokeShape(this);}};Kinetic.Util.extend(Kinetic.RegularPolygon,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.RegularPolygon,'radius',0);Kinetic.Factory.addGetterSetter(Kinetic.RegularPolygon,'sides',0);Kinetic.Collection.mapMethods(Kinetic.RegularPolygon);})();;(function(){Kinetic.Star=function(config){this.___init(config);};Kinetic.Star.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className='Star';this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){var innerRadius=this.innerRadius(),outerRadius=this.outerRadius(),numPoints=this.numPoints();context.beginPath();context.moveTo(0,0-outerRadius);for(var n=1;n<numPoints*2;n++){var radius=n%2===0?outerRadius:innerRadius;var x=radius*Math.sin(n*Math.PI/numPoints);var y=-1*radius*Math.cos(n*Math.PI/numPoints);context.lineTo(x,y);}
context.closePath();context.fillStrokeShape(this);}};Kinetic.Util.extend(Kinetic.Star,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Star,'numPoints',5);Kinetic.Factory.addGetterSetter(Kinetic.Star,'innerRadius',0);Kinetic.Factory.addGetterSetter(Kinetic.Star,'outerRadius',0);Kinetic.Collection.mapMethods(Kinetic.Star);})();;(function(){var ATTR_CHANGE_LIST=['fontFamily','fontSize','fontStyle','padding','lineHeight','text'],CHANGE_KINETIC='Change.kinetic',NONE='none',UP='up',RIGHT='right',DOWN='down',LEFT='left',LABEL='Label',attrChangeListLen=ATTR_CHANGE_LIST.length;Kinetic.Label=function(config){this.____init(config);};Kinetic.Label.prototype={____init:function(config){var that=this;this.className=LABEL;Kinetic.Group.call(this,config);this.on('add.kinetic',function(evt){that._addListeners(evt.child);that._sync();});},getText:function(){return this.find('Text')[0];},getTag:function(){return this.find('Tag')[0];},_addListeners:function(text){var that=this,n;var func=function(){that._sync();};for(n=0;n<attrChangeListLen;n++){text.on(ATTR_CHANGE_LIST[n]+CHANGE_KINETIC,func);}},getWidth:function(){return this.getText().getWidth();},getHeight:function(){return this.getText().getHeight();},_sync:function(){var text=this.getText(),tag=this.getTag(),width,height,pointerDirection,pointerWidth,x,y,pointerHeight;if(text&&tag){width=text.getWidth();height=text.getHeight();pointerDirection=tag.getPointerDirection();pointerWidth=tag.getPointerWidth();pointerHeight=tag.getPointerHeight();x=0;y=0;switch(pointerDirection){case UP:x=width/2;y=-1*pointerHeight;break;case RIGHT:x=width+pointerWidth;y=height/2;break;case DOWN:x=width/2;y=height+pointerHeight;break;case LEFT:x=-1*pointerWidth;y=height/2;break;}
tag.setAttrs({x:-1*x,y:-1*y,width:width,height:height});text.setAttrs({x:-1*x,y:-1*y});}}};Kinetic.Util.extend(Kinetic.Label,Kinetic.Group);Kinetic.Collection.mapMethods(Kinetic.Label);Kinetic.Tag=function(config){this.___init(config);};Kinetic.Tag.prototype={___init:function(config){Kinetic.Shape.call(this,config);this.className='Tag';this.sceneFunc(this._sceneFunc);},_sceneFunc:function(context){var width=this.getWidth(),height=this.getHeight(),pointerDirection=this.getPointerDirection(),pointerWidth=this.getPointerWidth(),pointerHeight=this.getPointerHeight();context.beginPath();context.moveTo(0,0);if(pointerDirection===UP){context.lineTo((width-pointerWidth)/2,0);context.lineTo(width/2,-1*pointerHeight);context.lineTo((width+pointerWidth)/2,0);}
context.lineTo(width,0);if(pointerDirection===RIGHT){context.lineTo(width,(height-pointerHeight)/2);context.lineTo(width+pointerWidth,height/2);context.lineTo(width,(height+pointerHeight)/2);}
context.lineTo(width,height);if(pointerDirection===DOWN){context.lineTo((width+pointerWidth)/2,height);context.lineTo(width/2,height+pointerHeight);context.lineTo((width-pointerWidth)/2,height);}
context.lineTo(0,height);if(pointerDirection===LEFT){context.lineTo(0,(height+pointerHeight)/2);context.lineTo(-1*pointerWidth,height/2);context.lineTo(0,(height-pointerHeight)/2);}
context.closePath();context.fillStrokeShape(this);}};Kinetic.Util.extend(Kinetic.Tag,Kinetic.Shape);Kinetic.Factory.addGetterSetter(Kinetic.Tag,'pointerDirection',NONE);Kinetic.Factory.addGetterSetter(Kinetic.Tag,'pointerWidth',0);Kinetic.Factory.addGetterSetter(Kinetic.Tag,'pointerHeight',0);Kinetic.Factory.addGetterSetter(Kinetic.Tag,'cornerRadius',0);Kinetic.Collection.mapMethods(Kinetic.Tag);})();
